package com.ejianc.business.safe.service.impl;

import com.ejianc.business.safe.bean.SafeMangerPersonCheckEntity;
import com.ejianc.business.safe.bean.SafeMangerPersonCheckSubEntity;
import com.ejianc.business.safe.bean.SafeMangerPersonCheckTabEntity;
import com.ejianc.business.safe.service.ISafeMangerPersonCheckService;
import com.ejianc.business.safe.service.ISafeMangerPersonCheckTabService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("safeMangerPersonCheck") 
public class SafeMangerPersonCheckBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISafeMangerPersonCheckService service;
	@Autowired
	private ISafeMangerPersonCheckTabService tabService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SafeMangerPersonCheckEntity entity = service.selectById(billId);
		if(ListUtil.isEmpty(entity.getSafeMangerPersonCheckSubList())){
			return CommonResponse.error("请先添加人员清单信息");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SafeMangerPersonCheckEntity entity = service.selectById(billId);
		List<SafeMangerPersonCheckSubEntity> subList = entity.getSafeMangerPersonCheckSubList();
		List<SafeMangerPersonCheckTabEntity> tabList = new ArrayList<>();
		for (SafeMangerPersonCheckSubEntity checkSubEntity : subList) {
			SafeMangerPersonCheckTabEntity tabEntity = new SafeMangerPersonCheckTabEntity();
			tabEntity.setMainId(billId);
			tabEntity.setCode(entity.getCode());
			tabEntity.setSubId(checkSubEntity.getId());
			tabEntity.setProjectId(entity.getProjectId());
			tabEntity.setProjectName(entity.getProjectName());
			tabEntity.setOrgId(entity.getOrgId());
			tabEntity.setOrgName(entity.getOrgName());
			tabEntity.setUserId(checkSubEntity.getUserId());
			tabEntity.setUserName(checkSubEntity.getUserName());
			tabEntity.setZhiwuNow(checkSubEntity.getZhiwuNow());
			tabEntity.setGangweiNow(checkSubEntity.getGangweiNow());
			tabEntity.setEdu(checkSubEntity.getEdu());
			tabEntity.setMajor(checkSubEntity.getMajor());
			tabEntity.setExpYear(checkSubEntity.getExpYear());
			tabEntity.setRegNum(checkSubEntity.getRegNum());
			tabEntity.setSafeNum(checkSubEntity.getSafeNum());
			tabEntity.setMemo(checkSubEntity.getMemo());
			tabList.add(tabEntity);
		}
		tabService.saveOrUpdateBatch(tabList);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("弃审失败，不支持弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
