package com.ejianc.business.safe.vo;

import java.util.Date;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目开工安全检查验收报告表
 * 
 * @author generator
 * 
 */
public class SafeCheckReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据审批状态
    private String code; // 单据编码
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 所属单位
    private String orgName; // 所属单位
    private String manger; // 项目经理
    private String mangerPhone; // 项目经理电话
    private Long techManger; // 技术负责人
    private String techMangerPhone; // 技术负责人电话
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date mayStartDate; // 预计开工时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date mayEndDate; // 预计结束时间
    private String workAddress; // 施工地点
    private Long safer; // 安全员
    private String saferName; // 安全员
    private Integer totalPersonNum; // 总人数
    private Integer totalGroupNum; // 总人员组数
    private Integer outPersonNum; // 外协队伍人数
    private Integer outGroupNum; // 外协队伍组数
    private Boolean signSafeProtol; // 是否签订安全生产协议
    private Integer carNum; // 车辆数
    private Boolean carAgree; // 所属单位是否批准
    private String driverInfo; // 驾驶人姓名、驾龄
    private Boolean matchRequire; // 车况、手续是否符合要求
    private String signSafeTarget; // 项目安全目标责任书签订
    private String safeEdu; // 员工安全教育培训
    private String newEmpSafeEdu; // 新员工三级安全教育
    private String mainDanger; // 主要危险源
    private String preCtrlMeasures; // 预防控制措施
    private Boolean giveOut; //  发放记录 是否发放
    private Integer insuTrackingDry; // 绝缘跟踪干（含外协）
    private Integer warmMark; // 警示标志（牌）
    private Integer reflectiveVest; // 反光衣
    private Integer safeShoe; // 劳保鞋
    private Integer safeString; //  安全带（绳）
    private Integer gasTest; // 有害气体检测仪
    private Integer safeCap; // 安全帽
    private String otherSafeWay; // 其他安全措施

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getManger() {
        return manger;
    }

    public void setManger(String manger) {
        this.manger = manger;
    }
    public String getMangerPhone() {
        return mangerPhone;
    }

    public void setMangerPhone(String mangerPhone) {
        this.mangerPhone = mangerPhone;
    }
    @ReferSerialTransfer(referCode="idm-employee,idm-user")
    public Long getTechManger() {
        return techManger;
    }
    @ReferDeserialTransfer
    public void setTechManger(Long techManger) {
        this.techManger = techManger;
    }
    public String getTechMangerPhone() {
        return techMangerPhone;
    }

    public void setTechMangerPhone(String techMangerPhone) {
        this.techMangerPhone = techMangerPhone;
    }
    public Date getMayStartDate() {
        return mayStartDate;
    }

    public void setMayStartDate(Date mayStartDate) {
        this.mayStartDate = mayStartDate;
    }
    public Date getMayEndDate() {
        return mayEndDate;
    }

    public void setMayEndDate(Date mayEndDate) {
        this.mayEndDate = mayEndDate;
    }
    public String getWorkAddress() {
        return workAddress;
    }

    public void setWorkAddress(String workAddress) {
        this.workAddress = workAddress;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSafer() {
        return safer;
    }
    @ReferDeserialTransfer
    public void setSafer(Long safer) {
        this.safer = safer;
    }
    public String getSaferName() {
        return saferName;
    }

    public void setSaferName(String saferName) {
        this.saferName = saferName;
    }
    public Integer getTotalPersonNum() {
        return totalPersonNum;
    }

    public void setTotalPersonNum(Integer totalPersonNum) {
        this.totalPersonNum = totalPersonNum;
    }
    public Integer getTotalGroupNum() {
        return totalGroupNum;
    }

    public void setTotalGroupNum(Integer totalGroupNum) {
        this.totalGroupNum = totalGroupNum;
    }
    public Integer getOutPersonNum() {
        return outPersonNum;
    }

    public void setOutPersonNum(Integer outPersonNum) {
        this.outPersonNum = outPersonNum;
    }
    public Integer getOutGroupNum() {
        return outGroupNum;
    }

    public void setOutGroupNum(Integer outGroupNum) {
        this.outGroupNum = outGroupNum;
    }
    public Boolean getSignSafeProtol() {
        return signSafeProtol;
    }

    public void setSignSafeProtol(Boolean signSafeProtol) {
        this.signSafeProtol = signSafeProtol;
    }
    public Integer getCarNum() {
        return carNum;
    }

    public void setCarNum(Integer carNum) {
        this.carNum = carNum;
    }
    public Boolean getCarAgree() {
        return carAgree;
    }

    public void setCarAgree(Boolean carAgree) {
        this.carAgree = carAgree;
    }
    public String getDriverInfo() {
        return driverInfo;
    }

    public void setDriverInfo(String driverInfo) {
        this.driverInfo = driverInfo;
    }
    public Boolean getMatchRequire() {
        return matchRequire;
    }

    public void setMatchRequire(Boolean matchRequire) {
        this.matchRequire = matchRequire;
    }
    public String getSignSafeTarget() {
        return signSafeTarget;
    }

    public void setSignSafeTarget(String signSafeTarget) {
        this.signSafeTarget = signSafeTarget;
    }
    public String getSafeEdu() {
        return safeEdu;
    }

    public void setSafeEdu(String safeEdu) {
        this.safeEdu = safeEdu;
    }
    public String getNewEmpSafeEdu() {
        return newEmpSafeEdu;
    }

    public void setNewEmpSafeEdu(String newEmpSafeEdu) {
        this.newEmpSafeEdu = newEmpSafeEdu;
    }
    public String getMainDanger() {
        return mainDanger;
    }

    public void setMainDanger(String mainDanger) {
        this.mainDanger = mainDanger;
    }
    public String getPreCtrlMeasures() {
        return preCtrlMeasures;
    }

    public void setPreCtrlMeasures(String preCtrlMeasures) {
        this.preCtrlMeasures = preCtrlMeasures;
    }
    public Boolean getGiveOut() {
        return giveOut;
    }

    public void setGiveOut(Boolean giveOut) {
        this.giveOut = giveOut;
    }
    public Integer getInsuTrackingDry() {
        return insuTrackingDry;
    }

    public void setInsuTrackingDry(Integer insuTrackingDry) {
        this.insuTrackingDry = insuTrackingDry;
    }
    public Integer getWarmMark() {
        return warmMark;
    }

    public void setWarmMark(Integer warmMark) {
        this.warmMark = warmMark;
    }
    public Integer getReflectiveVest() {
        return reflectiveVest;
    }

    public void setReflectiveVest(Integer reflectiveVest) {
        this.reflectiveVest = reflectiveVest;
    }
    public Integer getSafeShoe() {
        return safeShoe;
    }

    public void setSafeShoe(Integer safeShoe) {
        this.safeShoe = safeShoe;
    }
    public Integer getSafeString() {
        return safeString;
    }

    public void setSafeString(Integer safeString) {
        this.safeString = safeString;
    }
    public Integer getGasTest() {
        return gasTest;
    }

    public void setGasTest(Integer gasTest) {
        this.gasTest = gasTest;
    }
    public Integer getSafeCap() {
        return safeCap;
    }

    public void setSafeCap(Integer safeCap) {
        this.safeCap = safeCap;
    }
    public String getOtherSafeWay() {
        return otherSafeWay;
    }

    public void setOtherSafeWay(String otherSafeWay) {
        this.otherSafeWay = otherSafeWay;
    }
    
}
