package com.ejianc.business.safe.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 新入职员工安全教育培训表
 * 
 * @author generator
 * 
 */
public class SafeEduVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据审批状态
    private String code; // 单据编码
    private String name; // 培训主题
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private Long eduType; // 培训类型：
    private Long processor; // 经办人
    private String procesorName; // 经办人
    private String memo; // 备注
    private String remark; // 培训内容
    private String eduPeople; // 授课人员
    private List<SafeEduSubVO> safeEduSubList = new ArrayList<>(); // 新入职员工安全教育培训表-子表

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getEduPeople() {
        return eduPeople;
    }

    public void setEduPeople(String eduPeople) {
        this.eduPeople = eduPeople;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEduType() {
        return eduType;
    }
    @ReferDeserialTransfer
    public void setEduType(Long eduType) {
        this.eduType = eduType;
    }
    @ReferSerialTransfer(referCode="idm-employee,idm-user")
    public Long getProcessor() {
        return processor;
    }
    @ReferDeserialTransfer
    public void setProcessor(Long processor) {
        this.processor = processor;
    }
    public String getProcesorName() {
        return procesorName;
    }

    public void setProcesorName(String procesorName) {
        this.procesorName = procesorName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<SafeEduSubVO> getSafeEduSubList() {
        return safeEduSubList;
     }

     public void setSafeEduSubList(List<SafeEduSubVO> safeEduSubList) {
        this.safeEduSubList = safeEduSubList;
     }
}
