package com.ejianc.business.sq.keyan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 里程碑
 * 
 * @author generator
 * 
 */
 @TableName("ejc_keyan_milestone")
public class KeyanMilestoneEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="unit_id")
    private Long unitId; // 所属单位id
    @TableField(value="unit_name")
    private String unitName; // 所属单位名称
    @TableField(value="establishment_user_id")
    private Long establishmentUserId; // 编制人id
    @TableField(value="establishment_user_name")
    private String establishmentUserName; // 编制人
    @TableField(value="establishment_date")
    private Date establishmentDate; // 编制时间
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="milestone_name")
    private String milestoneName; // 里程碑名称集集合

    @TableField(exist=false)
    @SubEntity(serviceName="keyanMilestoneDetailsService", pidName="pid")
    private List<KeyanMilestoneDetailsEntity> milestoneDetailsList = new ArrayList<>(); // 里程碑子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }

    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }

    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getMilestoneName() {
        return milestoneName;
    }

    public void setMilestoneName(String milestoneName) {
        this.milestoneName = milestoneName;
    }

    public List<KeyanMilestoneDetailsEntity> getMilestoneDetailsList() {
        return milestoneDetailsList;
    }

    public void setMilestoneDetailsList(List<KeyanMilestoneDetailsEntity> milestoneDetailsList) {
        this.milestoneDetailsList = milestoneDetailsList;
    }
}
