package com.ejianc.business.sq.keyan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanProjectAcceptanceApplicationEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectAcceptanceApplicationService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.vo.KeyanProjectAcceptanceApplicationVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 科研项目验收申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sq/keyan/projectAcceptanceApplication")
public class KeyanProjectAcceptanceApplicationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IKeyanProjectService keyanProjectService;

    private static final String BILL_CODE = "zydxKeyanProjectAcceptanceApplication";//此处需要根据实际修改

    @Autowired
    private IKeyanProjectAcceptanceApplicationService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KeyanProjectAcceptanceApplicationVO> saveOrUpdate(@RequestBody KeyanProjectAcceptanceApplicationVO saveOrUpdateVO) {
    	KeyanProjectAcceptanceApplicationEntity entity = BeanMapper.map(saveOrUpdateVO, KeyanProjectAcceptanceApplicationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	KeyanProjectAcceptanceApplicationVO vo = BeanMapper.map(entity, KeyanProjectAcceptanceApplicationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KeyanProjectAcceptanceApplicationVO> queryDetail(Long id) {
    	KeyanProjectAcceptanceApplicationEntity entity = service.selectById(id);
    	KeyanProjectAcceptanceApplicationVO vo = BeanMapper.map(entity, KeyanProjectAcceptanceApplicationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanProjectAcceptanceApplicationVO> vos) {
        service.removeByIds(vos.stream().map(KeyanProjectAcceptanceApplicationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KeyanProjectAcceptanceApplicationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectApprovalUnit");
        fuzzyFields.add("bearUnitName");
        fuzzyFields.add("projectLeaderName");
        fuzzyFields.add("acceptanceContactPersonName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("bearUnitId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<KeyanProjectAcceptanceApplicationEntity> page = service.queryPage(param,false);
        IPage<KeyanProjectAcceptanceApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanProjectAcceptanceApplicationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downTemplateUrl")
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "sq/keyanProjectAcceptanceApplication-import.xlsx", "科研项目验收申请模板");
    }
    /**
     * @Description excel导入数据检验
     */
    @RequestMapping(value = "/importCheckData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();

        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<>();
        fileds.addAll(Arrays.asList("projectName","acceptanceContactPersonName","applicationAcceptanceTime","remarks"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<>();
        filedsName.addAll(Arrays.asList("项目名称","验收联系人","申请验收时间","备注"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        Map<String, JSONObject> filedsConfig = new HashMap<>();
        JSONObject projectNameConfig = new JSONObject();
        projectNameConfig.put("keyanProject", "keyanProject");
        JSONObject projectNameMath = new JSONObject();
        projectNameMath.put("projectId", "id");
        projectNameMath.put("projectApprovalUnit", "projectApprovalUnit");
        projectNameMath.put("bearUnitId", "bearUnitId");
        projectNameMath.put("bearUnitName", "bearUnitName");
        projectNameMath.put("projectLeaderId", "projectLeaderId");
        projectNameMath.put("projectLeaderName", "projectLeaderName");
        projectNameMath.put("projectLeaderPhone", "projectLeaderPhone");
        projectNameMath.put("projectStartDate", "projectStartDate");
        projectNameMath.put("projectEndDate", "projectEndDate");
        projectNameConfig.put("fieldMath", projectNameMath);
        filedsConfig.put("projectName", projectNameConfig);

        JSONObject acceptanceContactPersonNameConfig = new JSONObject();
        acceptanceContactPersonNameConfig.put("user", "user");
        JSONObject acceptanceContactPersonNameMath = new JSONObject();
        acceptanceContactPersonNameMath.put("acceptanceContactPersonId", "id");
        acceptanceContactPersonNameMath.put("acceptanceContactPersonPhone", "mobilePhone");
        acceptanceContactPersonNameConfig.put("fieldMath", acceptanceContactPersonNameMath);
        filedsConfig.put("acceptanceContactPersonName", acceptanceContactPersonNameConfig);
        importUtil.setFiledsConfig(filedsConfig);//字段关联性配置信息

        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanProjectAcceptanceApplicationVO");
        importUtil.setServiceName("keyanProjectAcceptanceApplicationService");
        List<String> requiredFields = new ArrayList<>();//必填字段
        requiredFields.addAll(Arrays.asList("projectName","applicationAcceptanceTime"));
        importUtil.setRequiredFields(requiredFields);
//        List<String> uniqueneFields = new ArrayList<>();//唯一性字段
//        uniqueneFields.addAll(Arrays.asList("projectName"));
//        importUtil.setUniqueneFields(uniqueneFields);
        importUtil.setKeyanProjectService(keyanProjectService);
        importUtil.setEmployeeApi(employeeApi);
        importUtil.setiOrgApi(iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success("保存或修改单据成功！",json);
    }

    /**
     * @Description importDataSave 导入批量新增
     */
    @RequestMapping(value = "/importDataSave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanProjectAcceptanceApplicationVO> vos) {
        CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid(),vos.size());
        if(billCode.isSuccess() && billCode.getData().size() == vos.size()){
            List<KeyanProjectAcceptanceApplicationEntity> entitys = new ArrayList<>();
            for(int i=0; i<vos.size(); i++){
                KeyanProjectAcceptanceApplicationEntity entity = BeanMapper.map(vos.get(i), KeyanProjectAcceptanceApplicationEntity.class);
                entity.setBillCode(billCode.getData().get(i));
                entitys.add(entity);
            }
            service.saveOrUpdateBatch(entitys, entitys.size(), false);
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return CommonResponse.success("导入成功！");
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectApprovalUnit");
        fuzzyFields.add("bearUnitName");
        fuzzyFields.add("projectLeaderName");
        fuzzyFields.add("acceptanceContactPersonName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("bearUnitId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<KeyanProjectAcceptanceApplicationEntity> list = service.queryList(param);
        List<KeyanProjectAcceptanceApplicationVO> result = new ArrayList<>();
        if(list!=null && list.size()>0){
            result = BeanMapper.mapList(list, KeyanProjectAcceptanceApplicationVO.class);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result);
        ExcelExport.getInstance().exportWithTrans("sq/keyanProjectAcceptanceApplication-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKeyanProjectAcceptanceApplicationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KeyanProjectAcceptanceApplicationVO>> refKeyanProjectAcceptanceApplicationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KeyanProjectAcceptanceApplicationEntity> page = service.queryPage(param,false);
        IPage<KeyanProjectAcceptanceApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanProjectAcceptanceApplicationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
