package com.ejianc.business.sq.keyan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 科研项目验收申请
 * 
 * @author generator
 * 
 */
public class KeyanProjectAcceptanceApplicationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectApprovalUnit; // 立项单位
    private Long bearUnitId; // 承担单位id
    private String bearUnitName; // 承担单位名称
    private Long projectLeaderId; // 负责人
    private String projectLeaderName; // 负责人
    private String projectLeaderPhone; // 负责人联系电话
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartDate; // 项目开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectEndDate; // 项目结束时间
    private Long acceptanceContactPersonId; // 验收联系人
    private String acceptanceContactPersonName; // 验收联系人
    private String acceptanceContactPersonPhone; // 验收联系人电话
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applicationAcceptanceTime; // 申请验收时间
    private String remarks; // 备注

    private String errorMsg; // 导入错误信息

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="zydx-keyan-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectApprovalUnit() {
        return projectApprovalUnit;
    }

    public void setProjectApprovalUnit(String projectApprovalUnit) {
        this.projectApprovalUnit = projectApprovalUnit;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getBearUnitId() {
        return bearUnitId;
    }

    @ReferDeserialTransfer
    public void setBearUnitId(Long bearUnitId) {
        this.bearUnitId = bearUnitId;
    }
    public String getBearUnitName() {
        return bearUnitName;
    }

    public void setBearUnitName(String bearUnitName) {
        this.bearUnitName = bearUnitName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectLeaderId() {
        return projectLeaderId;
    }

    @ReferDeserialTransfer
    public void setProjectLeaderId(Long projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }

    public String getProjectLeaderName() {
        return projectLeaderName;
    }

    public void setProjectLeaderName(String projectLeaderName) {
        this.projectLeaderName = projectLeaderName;
    }
    public String getProjectLeaderPhone() {
        return projectLeaderPhone;
    }

    public void setProjectLeaderPhone(String projectLeaderPhone) {
        this.projectLeaderPhone = projectLeaderPhone;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getProjectEndDate() {
        return projectEndDate;
    }

    public void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getAcceptanceContactPersonId() {
        return acceptanceContactPersonId;
    }

    @ReferDeserialTransfer
    public void setAcceptanceContactPersonId(Long acceptanceContactPersonId) {
        this.acceptanceContactPersonId = acceptanceContactPersonId;
    }

    public String getAcceptanceContactPersonName() {
        return acceptanceContactPersonName;
    }

    public void setAcceptanceContactPersonName(String acceptanceContactPersonName) {
        this.acceptanceContactPersonName = acceptanceContactPersonName;
    }

    public String getAcceptanceContactPersonPhone() {
        return acceptanceContactPersonPhone;
    }

    public void setAcceptanceContactPersonPhone(String acceptanceContactPersonPhone) {
        this.acceptanceContactPersonPhone = acceptanceContactPersonPhone;
    }
    public Date getApplicationAcceptanceTime() {
        return applicationAcceptanceTime;
    }

    public void setApplicationAcceptanceTime(Date applicationAcceptanceTime) {
        this.applicationAcceptanceTime = applicationAcceptanceTime;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
    
}
