package com.ejianc.business.sq.operate.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 证书借阅
 * 
 * @author generator
 * 
 */
public class OperateCertificateBorrowVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long borrowerId; // 借阅人d
    private String borrowerName; // 借阅人名称
    private Long borrowerOrgId; // 借阅单位
    private String borrowerOrgName; // 借阅单位
    private Long orgId; // 创建组织id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date borrowerDate; // 借阅日期
    private String borroweCertificateName; // 借阅证书名称
    private String borrowerReason; // 借阅事由
    private String errorMsg; // 导入错误信息

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getBorrowerId() {
        return borrowerId;
    }

    @ReferDeserialTransfer
    public void setBorrowerId(Long borrowerId) {
        this.borrowerId = borrowerId;
    }

    public String getBorrowerName() {
        return borrowerName;
    }

    public void setBorrowerName(String borrowerName) {
        this.borrowerName = borrowerName;
    }

    public Long getBorrowerOrgId() {
        return borrowerOrgId;
    }

    public void setBorrowerOrgId(Long borrowerOrgId) {
        this.borrowerOrgId = borrowerOrgId;
    }

    public String getBorrowerOrgName() {
        return borrowerOrgName;
    }

    public void setBorrowerOrgName(String borrowerOrgName) {
        this.borrowerOrgName = borrowerOrgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getBorrowerDate() {
        return borrowerDate;
    }

    public void setBorrowerDate(Date borrowerDate) {
        this.borrowerDate = borrowerDate;
    }

    public String getBorroweCertificateName() {
        return borroweCertificateName;
    }

    public void setBorroweCertificateName(String borroweCertificateName) {
        this.borroweCertificateName = borroweCertificateName;
    }

    public String getBorrowerReason() {
        return borrowerReason;
    }

    public void setBorrowerReason(String borrowerReason) {
        this.borrowerReason = borrowerReason;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
