package com.ejianc.business.util;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.vo.KeyanProjectVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;

public class ImportCommonUtil {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private Integer dataStartLine = 0;//数据开始的行数
    private LinkedList<String> fileds;//导入数据的字段值
    private LinkedList<String> filedsName;//导入数据的字段显示值
    /**
     *
     *
     * 导入数据的字段配置信息，
     * format: 日期格式
     * uniquene：唯一性校验，
     * fieldMath: 字段匹配对应{
     * 导入字段键值：关联表字段键值
     *}
    **/
    private Map<String, JSONObject> filedsConfig;
    private HttpServletRequest request;

    private String voName;//vo全路径地址
    private String serviceName;//当前vo的service名称，供查询本单据数据

    private List<String> requiredFields;//必填字段
    private List<String> uniqueneFields;//唯一性字段
    private IOrgApi iOrgApi;
    private IEmployeeApi employeeApi;
    private IKeyanProjectService keyanProjectService;
    private IProjectApi marketProjectApi;

    public Integer getDataStartLine() {
        return dataStartLine;
    }

    public void setDataStartLine(Integer dataStartLine) {
        this.dataStartLine = dataStartLine;
    }

    public LinkedList<String> getFileds() {
        return fileds;
    }

    public void setFileds(LinkedList<String> fileds) {
        this.fileds = fileds;
    }

    public LinkedList<String> getFiledsName() {
        return filedsName;
    }

    public void setFiledsName(LinkedList<String> filedsName) {
        this.filedsName = filedsName;
    }

    public IOrgApi getiOrgApi() {
        return iOrgApi;
    }

    public void setiOrgApi(IOrgApi iOrgApi) {
        this.iOrgApi = iOrgApi;
    }

    public IEmployeeApi getEmployeeApi() {
        return employeeApi;
    }

    public void setEmployeeApi(IEmployeeApi employeeApi) {
        this.employeeApi = employeeApi;
    }

    public IKeyanProjectService getKeyanProjectService() {
        return keyanProjectService;
    }

    public void setKeyanProjectService(IKeyanProjectService keyanProjectService) {
        this.keyanProjectService = keyanProjectService;
    }

    public IProjectApi getMarketProjectApi() {
        return marketProjectApi;
    }

    public void setMarketProjectApi(IProjectApi marketProjectApi) {
        this.marketProjectApi = marketProjectApi;
    }

    public Map<String, JSONObject> getFiledsConfig() {
        return filedsConfig;
    }

    public void setFiledsConfig(Map<String, JSONObject> filedsConfig) {
        this.filedsConfig = filedsConfig;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getVoName() {
        return voName;
    }

    public void setVoName(String voName) {
        this.voName = voName;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<String> getRequiredFields() {
        return requiredFields;
    }

    public void setRequiredFields(List<String> requiredFields) {
        this.requiredFields = requiredFields;
    }

    public List<String> getUniqueneFields() {
        return uniqueneFields;
    }

    public void setUniqueneFields(List<String> uniqueneFields) {
        this.uniqueneFields = uniqueneFields;
    }

    public JSONObject importCheckData(){

        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<Object> successList = new ArrayList<>();
        List<Object> errorList = new ArrayList<>();

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        Map<String, Map<String,Object>> uniqueneMap = new HashMap();
        if(isFailed) {
            throw new BusinessException("文件格式不合法");
        }else {
            LinkedList<String> supperFields = new LinkedList<>();
            supperFields.addAll(Arrays.asList("id","createTime","updateUserCode","updateTime","dr",
                    "createUserCode","tenantId","syncEsFlag","rowState","version","createUserName", "updateUserName"));
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = dataStartLine-1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    try{
                        Class<?> voClass = Class.forName(voName);
                        Object voInstance = voClass.newInstance();
                        String allErrorMsg = "";
                        for(int j=0; j<fileds.size(); j++){
                            Field field = voClass.getDeclaredField(fileds.get(j));
                            String type = field.getGenericType().toString(); // 获取属性的类型
                            field.setAccessible(true); // 设置字段为可访问
                            Object dataValue = null;
                            String errorMsg = "";
                            if (type.equals("class java.lang.String")) { // 如果type是类类型，则前面包含"class "，后面跟类名
                                try{
                                    dataValue = datas.get(j);
                                }catch (Exception e){
                                    logger.info("解析第{}行字段{},值：{}，解析出错！{}",(i+dataStartLine),fileds.get(j),datas.get(j) ,e);
                                    if(errorMsg.length()>0){
                                        errorMsg += ("，"+filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }else{
                                        errorMsg = (filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }
                                }
                            }else if (type.equals("class java.util.Date")) {
                                try{
                                    Integer value = Integer.parseInt(datas.get(j));
                                    dataValue = org.apache.poi.ss.usermodel.DateUtil.getJavaDate(value);
                                }catch (Exception e){
                                    try{
                                        String pattern = "yyyy-MM-dd HH:mm:ss";
                                        if(filedsConfig.get(fileds.get(j))!=null){
                                            JSONObject ob = filedsConfig.get(fileds.get(j));
                                            if(ob.get("format")!=null){
                                                pattern = ob.getString("format");
                                            }
                                        }
                                        dataValue = DateUtil.parse(datas.get(j), pattern);
                                    }catch (Exception e1){
                                        logger.info("解析第{}行字段{},值：{}，解析出错！{}",(i+dataStartLine),fileds.get(j),datas.get(j) ,e1);
                                        if(errorMsg.length()>0){
                                            errorMsg += ("，"+filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                        }else{
                                            errorMsg = (filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                        }
                                    }
                                }
                            }else if (type.equals("class java.lang.Integer")) {
                                try{
                                    dataValue = Integer.parseInt(datas.get(j));
                                }catch (Exception e){
                                    logger.info("解析第{}行字段{},值：{}，解析出错！{}",(i+dataStartLine),fileds.get(j),datas.get(j) ,e);
                                    if(errorMsg.length()>0){
                                        errorMsg += ("，"+filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }else{
                                        errorMsg = (filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }
                                }
                            }else if (type.equals("class java.lang.Double")) {
                                try{
                                    dataValue = Double.valueOf(datas.get(j));
                                }catch (Exception e){
                                    logger.info("解析第{}行字段{},值：{}，解析出错！{}",(i+dataStartLine),fileds.get(j),datas.get(j) ,e);
                                    if(errorMsg.length()>0){
                                        errorMsg += ("，"+filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }else{
                                        errorMsg = (filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }
                                }
                            }else if (type.equals("class java.lang.Long")) {
                                try{
                                    dataValue = Long.valueOf(datas.get(j));
                                }catch (Exception e){
                                    logger.info("解析第{}行字段{},值：{}，解析出错！{}",(i+dataStartLine),fileds.get(j),datas.get(j) ,e);
                                    if(errorMsg.length()>0){
                                        errorMsg += ("，"+filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }else{
                                        errorMsg = (filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }
                                }
                            }else if (type.equals("class java.lang.Boolean")) {
                                try{
                                    dataValue = Boolean.valueOf(datas.get(j));
                                }catch (Exception e){
                                    logger.info("解析第{}行字段{},值：{}，解析出错！{}",(i+dataStartLine),fileds.get(j),datas.get(j) ,e);
                                    if(errorMsg.length()>0){
                                        errorMsg += ("，"+filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }else{
                                        errorMsg = (filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }
                                }
                            }else if (type.equals("class java.math.BigDecimal")) {
                                try{
                                    dataValue = new BigDecimal(datas.get(j));
                                }catch (Exception e){
                                    logger.info("解析第{}行字段{},值：{}，解析出错！{}",(i+dataStartLine),fileds.get(j),datas.get(j) ,e);
                                    if(errorMsg.length()>0){
                                        errorMsg += ("，"+filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }else{
                                        errorMsg = (filedsName.get(j) + ":【" + dataValue + "】解析出错！");
                                    }
                                }
                            }
                            field.set(voInstance, dataValue);
                            if(errorMsg.length()>0){
                                //数据解析错误
                                allErrorMsg += (errorMsg+";");
                                continue;
                            }
                            if("operateDataReviewFilingeService".equals(serviceName)){
                                //是否项目--手动判断项目名称的必填
                                if("whetherRelatedProject".equals(fileds.get(j))){
                                    if("是".equals(datas.get(0)) && StringUtils.isBlank(datas.get(1))){
                                        allErrorMsg += ("【项目名称】"+"数据不能为空;");
                                        continue;
                                    }else if( (StringUtils.isBlank(datas.get(1)) || "否".equals(datas.get(0))) && StringUtils.isNotBlank(datas.get(1))){
                                        datas.set(1, "");
                                    }
                                }
                            }
                            if(requiredFields!=null && requiredFields.contains(fileds.get(j)) && (dataValue == null || StringUtils.isBlank(dataValue.toString()))){
                                //必填校验
                                allErrorMsg += (filedsName.get(j) + "】数据不能为空;");
                                continue;
                            }
                            if(dataValue!=null && StringUtils.isNotBlank(dataValue.toString())){
                                if(filedsConfig!=null && filedsConfig.get(fileds.get(j))!=null){
                                    JSONObject ob = filedsConfig.get(fileds.get(j));
                                    if(ob.get("org")!=null && ob.get("fieldMath")!=null){
                                        //需要查询组织数据
                                        if(uniqueneMap.get("org")!=null && uniqueneMap.get("org").get(dataValue)!=null){
                                            OrgVO org = (OrgVO) uniqueneMap.get("org").get(dataValue);
                                            JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                            for(String fie : fieldMath.keySet()){
                                                Field f = voClass.getDeclaredField(fie);
                                                f.setAccessible(true); // 设置字段为可访问
                                                if(supperFields.contains(fieldMath.getString(fie))){
                                                    //父级类中的字段
                                                    Field of = OrgVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    f.set(voInstance, of.get(org));
                                                }else{
                                                    Field of = OrgVO.class.getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    f.set(voInstance, of.get(org));
                                                }
                                            }
                                        }else{
                                            try{
                                                CommonResponse<OrgVO> orgResponse = iOrgApi.findByNameAndTenantId(dataValue.toString(), InvocationInfoProxy.getTenantid());
                                                if(orgResponse.isSuccess() && orgResponse.getData()!=null){
                                                    OrgVO org = orgResponse.getData();
                                                    if(org==null){
                                                        allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，未获取到组织数据;");
                                                        continue;
                                                    }
                                                    if(uniqueneMap.get("org")!=null){
                                                        Map<String,Object> o = uniqueneMap.get("org");
                                                        o.put(dataValue.toString(), org);
                                                        uniqueneMap.put("org", o);
                                                    }else{
                                                        Map<String,Object> o = new HashMap<>();
                                                        o.put(dataValue.toString(), org);
                                                        uniqueneMap.put("org", o);
                                                    }
                                                    JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                                    for(String fie : fieldMath.keySet()){
                                                        Field f = voClass.getDeclaredField(fie);
                                                        f.setAccessible(true); // 设置字段为可访问
                                                        if(supperFields.contains(fieldMath.getString(fie))){
                                                            //父级类中的字段
                                                            Field of = OrgVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            f.set(voInstance, of.get(org));
                                                        }else{
                                                            Field of = OrgVO.class.getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            f.set(voInstance, of.get(org));
                                                        }
                                                    }
                                                }else{
                                                    allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，未获取到组织数据;");
                                                    continue;
                                                }
                                            }catch (Exception e){
                                                logger.info("获取组织数据失败：{}", e);
                                                allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，未获取到组织数据;");
                                                continue;
                                            }
                                        }
                                    }
                                    if(ob.get("user")!=null) {
                                        //需要查询人员数据
                                        if (uniqueneMap.get("user") != null && uniqueneMap.get("user").get(dataValue) != null) {
                                            EmployeeVO employee = (EmployeeVO) uniqueneMap.get("user").get(dataValue);
                                            JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                            for (String fie : fieldMath.keySet()) {
                                                Field f = voClass.getDeclaredField(fie);
                                                f.setAccessible(true); // 设置字段为可访问
                                                if(supperFields.contains(fieldMath.getString(fie))){
                                                    //父级类中的字段
                                                    Field of = EmployeeVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    f.set(voInstance, of.get(employee));
                                                }else{
                                                    Field of = EmployeeVO.class.getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    f.set(voInstance, of.get(employee));
                                                }
                                            }
                                        } else {
                                            try {
                                                List<String> names = Arrays.asList(dataValue.toString());
                                                CommonResponse<Map<String, EmployeeVO>> userResponse = employeeApi.getEmployeeMapByNames(names);
                                                if (userResponse.isSuccess() && userResponse.getData() != null) {
                                                    Map<String, EmployeeVO> user = userResponse.getData();
                                                    EmployeeVO employee = user.get(dataValue.toString());
                                                    if(employee==null){
                                                        allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，未获取到人员数据;");
                                                        continue;
                                                    }
                                                    if(uniqueneMap.get("user")!=null){
                                                        Map<String,Object> o = uniqueneMap.get("user");
                                                        o.put(dataValue.toString(), employee);
                                                        uniqueneMap.put("user", o);
                                                    }else{
                                                        Map<String,Object> o = new HashMap<>();
                                                        o.put(dataValue.toString(), employee);
                                                        uniqueneMap.put("user", o);
                                                    }
                                                    JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                                    for (String fie : fieldMath.keySet()) {
                                                        Field f = voClass.getDeclaredField(fie);
                                                        f.setAccessible(true); // 设置字段为可访问
                                                        if(supperFields.contains(fieldMath.getString(fie))){
                                                            //父级类中的字段
                                                            Field of = EmployeeVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            f.set(voInstance, of.get(employee));
                                                        }else{
                                                            Field of = EmployeeVO.class.getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            f.set(voInstance, of.get(employee));
                                                        }
                                                    }
                                                } else {
                                                    allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，未获取到人员数据;");
                                                    continue;
                                                }
                                            } catch (Exception e) {
                                                logger.info("获取人员数据失败：{}", e);
                                                allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，未获取到人员数据;");
                                                continue;
                                            }
                                        }
                                    }

                                    if(ob.get("keyanProject")!=null && ob.get("fieldMath")!=null) {
                                        //需要查询组织数据
                                        if (uniqueneMap.get("keyanProject") != null && uniqueneMap.get("keyanProject").get(dataValue) != null) {
                                            KeyanProjectVO project = (KeyanProjectVO) uniqueneMap.get("keyanProject").get(dataValue);
                                            JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                            for (String fie : fieldMath.keySet()) {
                                                Field f = voClass.getDeclaredField(fie);
                                                f.setAccessible(true); // 设置字段为可访问
                                                if (supperFields.contains(fieldMath.getString(fie))) {
                                                    //父级类中的字段
                                                    Field of = KeyanProjectVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    f.set(voInstance, of.get(project));
                                                } else {
                                                    Field of = KeyanProjectVO.class.getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    f.set(voInstance, of.get(project));
                                                }
                                            }
                                        } else {
                                            try {
                                                KeyanProjectVO project = keyanProjectService.getDataByName(dataValue.toString());
                                                if (project == null) {
                                                    allErrorMsg += (filedsName.get(j) + ":【" + dataValue + "】，未获取到项目数据;");
                                                    continue;
                                                } else {
                                                    if (uniqueneMap.get("keyanProject") != null) {
                                                        Map<String, Object> o = uniqueneMap.get("keyanProject");
                                                        o.put(dataValue.toString(), project);
                                                        uniqueneMap.put("keyanProject", o);
                                                    } else {
                                                        Map<String, Object> o = new HashMap<>();
                                                        o.put(dataValue.toString(), project);
                                                        uniqueneMap.put("keyanProject", o);
                                                    }
                                                    JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                                    for (String fie : fieldMath.keySet()) {
                                                        Field f = voClass.getDeclaredField(fie);
                                                        f.setAccessible(true); // 设置字段为可访问
                                                        if (supperFields.contains(fieldMath.getString(fie))) {
                                                            //父级类中的字段
                                                            Field of = KeyanProjectVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            f.set(voInstance, of.get(project));
                                                        } else {
                                                            Field of = KeyanProjectVO.class.getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            f.set(voInstance, of.get(project));
                                                        }
                                                    }
                                                }
                                            } catch (Exception e) {
                                                logger.info("获取项目数据失败：{}", e);
                                                allErrorMsg += (filedsName.get(j) + ":【" + dataValue + "】，获取到项目数据失败;");
                                                continue;
                                            }
                                        }
                                    }
                                    if(ob.get("marketProject")!=null && ob.get("fieldMath")!=null){
                                        //需要查询项目数据
                                        if(uniqueneMap.get("marketProject")!=null && uniqueneMap.get("marketProject").get(dataValue)!=null){
                                            ProjectRegisterVO project = (ProjectRegisterVO) uniqueneMap.get("marketProject").get(dataValue);
                                            JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                            for(String fie : fieldMath.keySet()){
                                                Field f = voClass.getDeclaredField(fie);
                                                f.setAccessible(true); // 设置字段为可访问
                                                if(supperFields.contains(fieldMath.getString(fie))){
                                                    //父级类中的字段
                                                    Field of = ProjectRegisterVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    f.set(voInstance, of.get(project));
                                                }else{
                                                    Field of = ProjectRegisterVO.class.getDeclaredField(fieldMath.getString(fie));
                                                    of.setAccessible(true); // 设置字段为可访问
                                                    if("projectType".equals(fie)){
                                                        //项目类型处理
                                                        String projectType = of.get(project).toString();
                                                        if("1".equals(projectType)){
                                                            projectType = "自营";
                                                        }else if("2".equals(projectType)){
                                                            projectType = "联营";
                                                        }
                                                        f.set(voInstance, projectType);
                                                    }else{
                                                        f.set(voInstance, of.get(project));
                                                    }
                                                }
                                            }
                                        }else{
                                            try{
                                                CommonResponse<ProjectRegisterVO> projectResponse = marketProjectApi.getDataByName(dataValue.toString());
                                                if(projectResponse.isSuccess() && projectResponse.getData()!=null){
                                                    ProjectRegisterVO project =projectResponse.getData();
                                                    if(uniqueneMap.get("marketProject")!=null){
                                                        Map<String,Object> o = uniqueneMap.get("marketProject");
                                                        o.put(dataValue.toString(), project);
                                                        uniqueneMap.put("marketProject", o);
                                                    }else{
                                                        Map<String,Object> o = new HashMap<>();
                                                        o.put(dataValue.toString(), project);
                                                        uniqueneMap.put("marketProject", o);
                                                    }
                                                    JSONObject fieldMath = (JSONObject) ob.get("fieldMath");
                                                    for(String fie : fieldMath.keySet()){
                                                        Field f = voClass.getDeclaredField(fie);
                                                        f.setAccessible(true); // 设置字段为可访问
                                                        if(supperFields.contains(fieldMath.getString(fie))){
                                                            //父级类中的字段
                                                            Field of = ProjectRegisterVO.class.getSuperclass().getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            f.set(voInstance, of.get(project));
                                                        }else{
                                                            Field of = ProjectRegisterVO.class.getDeclaredField(fieldMath.getString(fie));
                                                            of.setAccessible(true); // 设置字段为可访问
                                                            if("projectType".equals(fie)){
                                                                //项目类型处理
                                                                String projectType = of.get(project).toString();
                                                                if("1".equals(projectType)){
                                                                    projectType = "自营";
                                                                }else if("2".equals(projectType)){
                                                                    projectType = "联营";
                                                                }
                                                                f.set(voInstance, projectType);
                                                            }else{
                                                                f.set(voInstance, of.get(project));
                                                            }
                                                        }
                                                    }
                                                }else{
                                                    allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，未获取到项目数据;");
                                                    continue;
                                                }
                                            }catch (Exception e){
                                                logger.info("获取项目数据失败：{}", e);
                                                allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，获取到项目数据失败;");
                                                continue;
                                            }
                                        }
                                    }
                                }
                                if(uniqueneFields!=null && uniqueneFields.contains(fileds.get(j))){
                                    if(uniqueneMap.get(fileds.get(j))!=null && uniqueneMap.get(fileds.get(j)).get(dataValue)!=null){
                                        allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，excel中已存在重复编码数据;");
                                        continue;
                                    }else{
                                        if(uniqueneMap.get(fileds.get(j))!=null){
                                            Map<String,Object> o = uniqueneMap.get(fileds.get(j));
                                            o.put(dataValue.toString(), dataValue);
                                            uniqueneMap.put(fileds.get(j), o);
                                        }else{
                                            Map<String,Object> o = new HashMap<>();
                                            o.put(dataValue.toString(), dataValue);
                                            uniqueneMap.put(fileds.get(j), o);
                                        }
                                    }
                                    IBaseService businessService = ContextUtil.getBean(serviceName, IBaseService.class);
                                    QueryWrapper wrapper = new QueryWrapper();
                                    wrapper.eq(CamelAndUnderLineConverter.humpToLine(fileds.get(j)), dataValue);
                                    List list = businessService.list(wrapper);
                                    if(list!=null && list.size()>0){
                                        allErrorMsg += (filedsName.get(j)+":【"+dataValue+"】，数据库中已存在;");
                                        continue;
                                    }
                                }
                            }
                        }
                        if(allErrorMsg.length()>0){
                            setErrorMsg(voClass, voInstance, ("第" + (i + dataStartLine) + "行：" + allErrorMsg), errorList);
                            continue;
                        }
                        successList.add(voInstance);
                    }catch (Exception e){
                        logger.info("解析第{}行数据出错！{}",(i+dataStartLine),e);
                        throw new BusinessException("解析第"+(i+dataStartLine)+"行数据出错！");
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return json;
    }

    private void setErrorMsg(Class<?> voClass, Object voInstance, String errorMsg, List<Object> errorList) throws NoSuchFieldException, IllegalAccessException {
        Field f = voClass.getDeclaredField("errorMsg");
        f.setAccessible(true);
        f.set(voInstance, errorMsg);
        errorList.add(voInstance);
    }

}
