package com.ejianc.business.zyscene.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 巡检表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scene_inspection")
public class SceneInspectionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名
    @TableField(value="inspection_date")
    private Date inspectionDate; // 检查日期
    @TableField(value="inspection_user_id")
    private Long inspectionUserId; // 巡检负责人
    @TableField(value="inspection_user_name")
    private String inspectionUserName; // 巡检负责人
    @TableField(value="total_score")
    private BigDecimal totalScore; // 综合得分
    @TableField(value="memo")
    private String memo; // 巡检内容
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5审批中
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="sceneInspectionDetailService",pidName = "inspectionId")
    private List<SceneInspectionDetailEntity> sceneInspectionDetailList = new ArrayList<>(); // 巡检表-巡检内容
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getInspectionDate() {
        return inspectionDate;
    }

    public void setInspectionDate(Date inspectionDate) {
        this.inspectionDate = inspectionDate;
    }

    public Long getInspectionUserId() {
        return inspectionUserId;
    }

    public void setInspectionUserId(Long inspectionUserId) {
        this.inspectionUserId = inspectionUserId;
    }

    public String getInspectionUserName() {
        return inspectionUserName;
    }

    public void setInspectionUserName(String inspectionUserName) {
        this.inspectionUserName = inspectionUserName;
    }

    public BigDecimal getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(BigDecimal totalScore) {
        this.totalScore = totalScore;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<SceneInspectionDetailEntity> getSceneInspectionDetailList() {
        return sceneInspectionDetailList;
    }

    public void setSceneInspectionDetailList(List<SceneInspectionDetailEntity> sceneInspectionDetailList) {
        this.sceneInspectionDetailList = sceneInspectionDetailList;
    }
}
