package com.ejianc.business.zyscene.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.zyscene.service.ISceneCheckService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * TODO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping("/bi")
public class BiController {
  private final Logger logger = LoggerFactory.getLogger(this.getClass());
  @Resource private IProjectApi projectApi;
  @Resource private ISceneCheckService sceneCheckService;


  /**
   * @description: 项目看板-质量分析
   *
   * @param projectId
   * @return {@link CommonResponse< JSONObject>}
   * @author songlx
   * @date: 2024/12/19
   */
  @GetMapping("/queryQualityCount")
  public CommonResponse<JSONObject> queryQualityCount(@RequestParam("projectId") Long projectId) {
    JSONObject js = sceneCheckService.queryQualityOrSafeCount(projectId, "1");
    return CommonResponse.success(js);
  }


  /**
   * @description: 项目看板-安全分析
   *
   * @param projectId
   * @return {@link CommonResponse< JSONObject>}
   * @author songlx
   * @date: 2024/12/19
   */
  @GetMapping("/querySafeCount")
  public CommonResponse<JSONObject> querySafeCount(@RequestParam("projectId") Long projectId) {
    JSONObject js = sceneCheckService.queryQualityOrSafeCount(projectId, "2");
    return CommonResponse.success(js);
  }

}
