package com.ejianc.business.zyscene.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zyscene.bean.SceneCheckDetailEntity;
import com.ejianc.business.zyscene.bean.SceneCheckEntity;
import com.ejianc.business.zyscene.service.CheckMessageService;
import com.ejianc.business.zyscene.service.ISceneCheckDetailService;
import com.ejianc.business.zyscene.service.ISceneCheckService;
import com.ejianc.business.zyscene.util.CheckItemReformState;
import com.ejianc.business.zyscene.util.NoticeEnum;
import com.ejianc.business.zyscene.util.OverdueState;
import com.ejianc.business.zyscene.vo.SceneCheckDetailVO;
import com.ejianc.business.zyscene.vo.SceneCheckVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


@RestController
@RequestMapping(value = "/overdueWarn")
public class OverdueWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private CheckMessageService checkMessageService;
    //逾期间隔天数
    private static Integer INTERVAL=2;


    @RequestMapping(value = "/overdue", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SceneCheckDetailVO>> overdue(HttpServletRequest request) {
        logger.info("接收到现场管理Task参数：{}", request);
        //修改逾期状态和检查结果状态描述
        service.updateSceneCheckOverdue();
        //修改逾期数量
        service.updateSceneCheckOverdueNumber();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_overdue",new Parameter(QueryParam.NE, Integer.parseInt(OverdueState.OVERDUE_STATE.getCode())));
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.or();
        wrapper.apply("is_overdue is null");
        List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckDetailService.list(wrapper);
        List<SceneCheckDetailEntity> list = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(item->{
                //要求完成的时间
                String finishDate = DateUtil.format(item.getFinishDate(), "yyyy-MM-dd");
                //获取要求完成的时间
                long finishTime = DateUtil.parse(finishDate).getTime();
                String today= DateUtil.today();
                //时间间隔小于两天
                long l = (finishTime - DateUtil.parse(today).getTime()) / (24 * 3600 * 1000);
                if (l<=2 && (finishTime - DateUtil.parse(today).getTime()>0)) {
                    list.add(item);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Integer, List<SceneCheckDetailEntity>> map = list.stream().collect(Collectors.groupingBy(SceneCheckDetailEntity::getIsReform));
            //带整改
            if (map.containsKey(Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()))){
                List<SceneCheckDetailEntity> entityList = map.get(Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                List<Long> ids = entityList.stream().map(SceneCheckDetailEntity::getPid).distinct().collect(Collectors.toList());
                QueryParam reformQueryParam = new QueryParam();
                reformQueryParam.getParams().put("id",new Parameter(QueryParam.IN, ids));
                List<SceneCheckEntity> sceneCheckEntities = service.queryList(reformQueryParam);
                if (CollectionUtils.isNotEmpty(sceneCheckEntities)) {
                    List<SceneCheckVO> sceneCheckVOList = BeanMapper.mapList(sceneCheckEntities, SceneCheckVO.class);
                    sceneCheckVOList.forEach(item->{
                        String reformDutyId = item.getReformDutyId();
                        if(reformDutyId!=null) {
                            String[] reformDutyIds = reformDutyId.split(",");
                            QueryParam queryDetailParam = new QueryParam();
                            queryDetailParam.getParams().put("pid",new Parameter(QueryParam.EQ, item.getId()));
                            queryDetailParam.getParams().put("is_reform",new Parameter(QueryParam.EQ, Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode())));
                            queryDetailParam.getParams().put("is_overdue",new Parameter(QueryParam.NE, Integer.parseInt(OverdueState.OVERDUE_STATE.getCode())));
                            int size = sceneCheckDetailService.queryList(queryDetailParam).size();
                            item.setMsgNum(size);
                            item.setMsgBillCode("0");
                            item.setMsgId(Long.parseLong("0"));
                            checkMessageService.sendMsg(item,reformDutyIds, NoticeEnum.REFORM_OVERTIME);
                        }
                    });
                }
            } if (map.containsKey(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()))){
                List<SceneCheckDetailEntity> entityList = map.get(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
                List<Long> ids = entityList.stream().map(SceneCheckDetailEntity::getPid).distinct().collect(Collectors.toList());
                QueryParam reformQueryParam = new QueryParam();
                reformQueryParam.getParams().put("id",new Parameter(QueryParam.IN, ids));
                List<SceneCheckEntity> sceneCheckEntities = service.queryList(reformQueryParam);
                if (CollectionUtils.isNotEmpty(sceneCheckEntities)) {
                    List<SceneCheckVO> sceneCheckVOList = BeanMapper.mapList(sceneCheckEntities, SceneCheckVO.class);
                    sceneCheckVOList.forEach(item->{
                        String reviewIds = item.getReviewId();
                        if(reviewIds!=null) {
                            String[] reviewPersonIs = reviewIds.split(",");
                            QueryParam queryDetailParam = new QueryParam();
                            queryDetailParam.getParams().put("pid",new Parameter(QueryParam.EQ, item.getId()));
                            queryDetailParam.getParams().put("is_reform",new Parameter(QueryParam.EQ, Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())));
                            queryDetailParam.getParams().put("is_overdue",new Parameter(QueryParam.NE, Integer.parseInt(OverdueState.OVERDUE_STATE.getCode())));
                            int size = sceneCheckDetailService.queryList(queryDetailParam).size();
                            item.setMsgNum(size);
                            //用不到 设置为null
                            item.setMsgBillCode("0");
                            item.setMsgId(Long.parseLong("0"));
                            checkMessageService.sendMsg(item,reviewPersonIs, NoticeEnum.REVIEW_OVERTIME);
                        }
                    });
                }
            }
        }
        List<SceneCheckDetailVO> SceneCheckList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        return CommonResponse.success("更新成功！",SceneCheckList);
    }
}
