package com.ejianc.business.zyscene.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zyscene.bean.SceneSafetyCheckItemEntity;
import com.ejianc.business.zyscene.mapper.SceneSafetyCheckItemMapper;
import com.ejianc.business.zyscene.service.ISceneSafetyCheckItemService;
import com.ejianc.business.zyscene.vo.SceneSafetyCheckItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 资源管理-安全检查项表
 * 
 * @author generator
 * 
 */
@Service("sceneSafetyCheckItemService")
public class SceneSafetyCheckItemServiceImpl extends BaseServiceImpl<SceneSafetyCheckItemMapper, SceneSafetyCheckItemEntity> implements ISceneSafetyCheckItemService{

    @Override
    public List<SceneSafetyCheckItemVO> queryListByCategoryId(List<Long> categoryIds) {
        List<SceneSafetyCheckItemVO> resp = new ArrayList<>();
        QueryWrapper<SceneSafetyCheckItemEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SceneSafetyCheckItemEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, SceneSafetyCheckItemVO.class);
        }
        return resp;
    }

    @Override
    public SceneSafetyCheckItemEntity getByCode(String code) {
        QueryWrapper<SceneSafetyCheckItemEntity> query = new QueryWrapper<>();
        query.in("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.getOne(query);
    }
}
