package com.ejianc.business.zyscene.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 巡检表
 * 
 * @author generator
 * 
 */
public class SceneInspectionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织名
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date inspectionDate; // 检查日期
    private Long inspectionUserId; // 巡检负责人
    private String inspectionUserName; // 巡检负责人
    private BigDecimal totalScore; // 综合得分
    private String memo; // 巡检内容
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5审批中
    private String billStateName;

    private List<SceneInspectionDetailVO> sceneInspectionDetailList = new ArrayList<>(); // 巡检表-巡检内容

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getInspectionDate() {
        return inspectionDate;
    }

    public void setInspectionDate(Date inspectionDate) {
        this.inspectionDate = inspectionDate;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getInspectionUserId() {
        return inspectionUserId;
    }
    @ReferDeserialTransfer
    public void setInspectionUserId(Long inspectionUserId) {
        this.inspectionUserId = inspectionUserId;
    }

    public String getInspectionUserName() {
        return inspectionUserName;
    }

    public void setInspectionUserName(String inspectionUserName) {
        this.inspectionUserName = inspectionUserName;
    }

    public BigDecimal getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(BigDecimal totalScore) {
        this.totalScore = totalScore;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<SceneInspectionDetailVO> getSceneInspectionDetailList() {
        return sceneInspectionDetailList;
     }

     public void setSceneInspectionDetailList(List<SceneInspectionDetailVO> sceneInspectionDetailList) {
        this.sceneInspectionDetailList = sceneInspectionDetailList;
     }
}
