/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjdocs.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prjdocs.bean.PrjCompletionAssessmentEntity;
import com.ejianc.business.prjdocs.mapper.PrjCompletionAssessmentMapper;
import com.ejianc.business.prjdocs.service.IPrjCompletionAssessmentItemService;
import com.ejianc.business.prjdocs.service.IPrjCompletionAssessmentService;
import com.ejianc.business.prjdocs.vo.PrjCompletionAssessmentItemVO;
import com.ejianc.business.prjdocs.vo.PrjCompletionAssessmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prjCompletionAssessmentService")
public class PrjCompletionAssessmentServiceImpl
extends BaseServiceImpl<PrjCompletionAssessmentMapper, PrjCompletionAssessmentEntity>
implements IPrjCompletionAssessmentService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPrjCompletionAssessmentItemService itemService;
    private static final String BILL_CODE = "zydxCompletionAssessment";

    private static void sortIntMethod(List<PrjCompletionAssessmentItemVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                PrjCompletionAssessmentItemVO o1Detail = (PrjCompletionAssessmentItemVO)((Object)objectMapper.convertValue(o1, PrjCompletionAssessmentItemVO.class));
                PrjCompletionAssessmentItemVO o2Detail = (PrjCompletionAssessmentItemVO)((Object)objectMapper.convertValue(o2, PrjCompletionAssessmentItemVO.class));
                String[] strs1 = o1Detail.getItemCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getItemCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public PrjCompletionAssessmentVO saveData(PrjCompletionAssessmentVO saveOrUpdateVO) {
        PrjCompletionAssessmentEntity entity = (PrjCompletionAssessmentEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PrjCompletionAssessmentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        PrjCompletionAssessmentVO vo = (PrjCompletionAssessmentVO)((Object)BeanMapper.map((Object)((Object)entity), PrjCompletionAssessmentVO.class));
        if (CollectionUtils.isNotEmpty(vo.getItemList())) {
            PrjCompletionAssessmentServiceImpl.sortIntMethod(vo.getItemList());
        }
        return vo;
    }

    @Override
    public PrjCompletionAssessmentVO queryDetail(Long id) {
        PrjCompletionAssessmentEntity entity = (PrjCompletionAssessmentEntity)((Object)this.selectById(id));
        PrjCompletionAssessmentVO vo = (PrjCompletionAssessmentVO)((Object)BeanMapper.map((Object)((Object)entity), PrjCompletionAssessmentVO.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("assessmentId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("itemCode", "asc");
        List detailEntityList = this.itemService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, PrjCompletionAssessmentItemVO.class);
            PrjCompletionAssessmentServiceImpl.sortIntMethod(resultMapList);
            vo.setItemList(resultMapList);
        }
        return vo;
    }
}

