/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjdocs.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prjdocs.bean.PrjexecuteSecureInspectionEntity;
import com.ejianc.business.prjdocs.mapper.PrjexecuteSecureInspectionMapper;
import com.ejianc.business.prjdocs.service.IPrjexecuteSecureInspectionItemService;
import com.ejianc.business.prjdocs.service.IPrjexecuteSecureInspectionService;
import com.ejianc.business.prjdocs.vo.PrjexecuteSecureInspectionItemVO;
import com.ejianc.business.prjdocs.vo.PrjexecuteSecureInspectionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prjexecuteSecureInspectionService")
public class PrjexecuteSecureInspectionServiceImpl
extends BaseServiceImpl<PrjexecuteSecureInspectionMapper, PrjexecuteSecureInspectionEntity>
implements IPrjexecuteSecureInspectionService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPrjexecuteSecureInspectionItemService itemService;
    private static final String BILL_CODE = "zydxSecureInspection";

    private static void sortIntMethod(List<PrjexecuteSecureInspectionItemVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                PrjexecuteSecureInspectionItemVO o1Detail = (PrjexecuteSecureInspectionItemVO)((Object)objectMapper.convertValue(o1, PrjexecuteSecureInspectionItemVO.class));
                PrjexecuteSecureInspectionItemVO o2Detail = (PrjexecuteSecureInspectionItemVO)((Object)objectMapper.convertValue(o2, PrjexecuteSecureInspectionItemVO.class));
                String[] strs1 = o1Detail.getItemCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getItemCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public PrjexecuteSecureInspectionVO saveData(PrjexecuteSecureInspectionVO saveOrUpdateVO) {
        PrjexecuteSecureInspectionEntity entity = (PrjexecuteSecureInspectionEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PrjexecuteSecureInspectionEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        PrjexecuteSecureInspectionVO vo = (PrjexecuteSecureInspectionVO)((Object)BeanMapper.map((Object)((Object)entity), PrjexecuteSecureInspectionVO.class));
        if (CollectionUtils.isNotEmpty(vo.getItemList())) {
            PrjexecuteSecureInspectionServiceImpl.sortIntMethod(vo.getItemList());
        }
        return vo;
    }

    @Override
    public PrjexecuteSecureInspectionVO queryDetail(Long id) {
        PrjexecuteSecureInspectionEntity entity = (PrjexecuteSecureInspectionEntity)((Object)this.selectById(id));
        PrjexecuteSecureInspectionVO vo = (PrjexecuteSecureInspectionVO)((Object)BeanMapper.map((Object)((Object)entity), PrjexecuteSecureInspectionVO.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("inspectionId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("itemCode", "asc");
        List detailEntityList = this.itemService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, PrjexecuteSecureInspectionItemVO.class);
            PrjexecuteSecureInspectionServiceImpl.sortIntMethod(resultMapList);
            vo.setItemList(resultMapList);
        }
        return vo;
    }
}

