/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sq.keyan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanProjectChangeEntity;
import com.ejianc.business.sq.keyan.bean.KeyanProjectDetailChangeEntity;
import com.ejianc.business.sq.keyan.bean.KeyanProjectEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectChangeService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectRecordService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.vo.KeyanProjectChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sq/keyan/projectChange"})
public class KeyanProjectChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "zydxKeyanProject";
    @Autowired
    private IKeyanProjectChangeService service;
    @Autowired
    private IKeyanProjectService keyanProjectService;
    @Autowired
    private IKeyanProjectRecordService keyanProjectRecordService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KeyanProjectChangeVO> saveOrUpdate(@RequestBody KeyanProjectChangeVO changeVO) {
        KeyanProjectChangeEntity changeEntity;
        List<KeyanProjectDetailChangeEntity> beforeDetails;
        boolean count = false;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(KeyanProjectChangeEntity::getOldMainId, (Object)changeVO.getOldMainId());
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.ne(KeyanProjectChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(KeyanProjectChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = this.service.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)changeVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                changeVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = (changeEntity = (KeyanProjectChangeEntity)((Object)BeanMapper.map((Object)((Object)changeVO), KeyanProjectChangeEntity.class))).getDetailList()) && null == changeEntity.getId() || CollectionUtils.isNotEmpty(beforeDetails) && this.service.getById(changeVO.getId()) == null) {
            for (KeyanProjectDetailChangeEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }
        this.service.saveOrUpdate((Object)changeEntity, false);
        this.saveWrite(changeEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)changeEntity), KeyanProjectChangeVO.class));
    }

    private void saveWrite(KeyanProjectChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(KeyanProjectEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(KeyanProjectEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(KeyanProjectEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(KeyanProjectEntity::getChangeState, (Object)2);
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getOldMainId());
        this.keyanProjectService.update(this.keyanProjectService.selectById(changeEntity.getOldMainId()), (Wrapper)updateWrapper, false);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KeyanProjectChangeVO> queryDetail(Long id) {
        KeyanProjectChangeEntity entity = (KeyanProjectChangeEntity)((Object)this.service.selectById(id));
        KeyanProjectChangeVO vo = (KeyanProjectChangeVO)((Object)BeanMapper.map((Object)((Object)entity), KeyanProjectChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/addConvertByMainId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KeyanProjectChangeVO> addConvertByMainId(Long mainId) {
        KeyanProjectChangeVO vo = this.service.addConvertByMainId(mainId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanProjectChangeVO> vos) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (ListUtil.isNotEmpty(vos)) {
            for (KeyanProjectChangeVO vo : vos) {
                KeyanProjectChangeEntity e = (KeyanProjectChangeEntity)((Object)this.service.selectById(vo.getId()));
                if (!BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState()) && !BillStateEnum.UNAPPROVED.getBillStateCode().equals(e.getBillState())) {
                    throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u53ea\u80fd\u5220\u9664\u81ea\u7531\u6001/\u5ba1\u6279\u9a73\u56de\u7684\u53d8\u66f4\u6570\u636e\uff01");
                }
                Integer changeState = 1;
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("old_main_id", new Parameter("eq", (Object)vo.getOldMainId()));
                List changeRecords = this.keyanProjectRecordService.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty((Collection)changeRecords)) {
                    changeState = 3;
                }
                KeyanProjectEntity entity = (KeyanProjectEntity)((Object)this.keyanProjectService.selectById(e.getOldMainId()));
                entity.setChangeState(changeState);
                entity.setChangeId(null);
                entity.setChangeCode(null);
                entity.setChangeVersion(entity.getChangeVersion() - 1);
                this.keyanProjectService.saveOrUpdate((Object)entity, false);
                ids.add(vo.getId());
            }
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KeyanProjectChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanProjectChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("KeyanProjectChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refKeyanProjectChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<KeyanProjectChangeVO>> refKeyanProjectChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanProjectChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

