package com.ejianc.business.prjdocs.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 考核项
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjexecute_assessment_item")
public class PrjexecuteAssessmentItemEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="assessment_item_name")
    private String assessmentItemName; // 考核项名称
    @TableField(value="assessment_item_category")
    private String assessmentItemCategory; // 考核项类别
    @TableField(value="org_id")
    private Long orgId; // 所属单位id
    @TableField(value="org_name")
    private String orgName; // 所属单位
    @TableField(value="establishment_date")
    private Date establishmentDate; // 编制时间
    @TableField(value="remarks")
    private String remarks; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="prjexecuteAssessmentItemDetailService", pidName="assessmentId")
    private List<PrjexecuteAssessmentItemDetailEntity> detailList = new ArrayList<>(); // 考核项明细
    
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getAssessmentItemName() {
        return assessmentItemName;
    }

    public void setAssessmentItemName(String assessmentItemName) {
        this.assessmentItemName = assessmentItemName;
    }
    public String getAssessmentItemCategory() {
        return assessmentItemCategory;
    }

    public void setAssessmentItemCategory(String assessmentItemCategory) {
        this.assessmentItemCategory = assessmentItemCategory;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<PrjexecuteAssessmentItemDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PrjexecuteAssessmentItemDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
