package com.ejianc.business.safe.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 新入职员工安全教育培训表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_safe_edu")
public class SafeEduEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="name")
    private String name; // 培训主题
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="edu_type")
    private Long eduType; // 培训类型：
    @TableField(value="processor")
    private Long processor; // 经办人
    @TableField(value="procesor_name")
    private String procesorName; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="remark")
    private String remark; // 培训内容
    @TableField(value="edu_people")
    private String eduPeople; // 授课人员

    
    @TableField(exist=false)
    @SubEntity(serviceName="safeEduSubService")
    private List<SafeEduSubEntity> safeEduSubList = new ArrayList<>(); // 新入职员工安全教育培训表-子表

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getEduPeople() {
        return eduPeople;
    }

    public void setEduPeople(String eduPeople) {
        this.eduPeople = eduPeople;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public Long getEduType() {
        return eduType;
    }

    public void setEduType(Long eduType) {
        this.eduType = eduType;
    }
    public Long getProcessor() {
        return processor;
    }

    public void setProcessor(Long processor) {
        this.processor = processor;
    }
    public String getProcesorName() {
        return procesorName;
    }

    public void setProcesorName(String procesorName) {
        this.procesorName = procesorName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<SafeEduSubEntity> getSafeEduSubList() {
        return safeEduSubList;
    }

    public void setSafeEduSubList(List<SafeEduSubEntity> safeEduSubList) {
        this.safeEduSubList = safeEduSubList;
    }
}
