package com.ejianc.business.sq.keyan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sq.keyan.bean.KeyanProjectDetailEntity;
import com.ejianc.business.sq.keyan.mapper.KeyanProjectDetailMapper;
import com.ejianc.business.sq.keyan.vo.KeyanProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sq.keyan.mapper.KeyanProjectMapper;
import com.ejianc.business.sq.keyan.bean.KeyanProjectEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;

import java.util.List;

/**
 * 在研项目立项
 * 
 * @author generator
 * 
 */
@Service("keyanProjectService")
public class KeyanProjectServiceImpl extends BaseServiceImpl<KeyanProjectMapper, KeyanProjectEntity> implements IKeyanProjectService{
    @Autowired
    private KeyanProjectDetailMapper keyanProjectDetailMapper;

    @Override
    public KeyanProjectVO getDataByName(String projectName) {
        QueryWrapper<KeyanProjectEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_name", projectName);
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<KeyanProjectEntity> list = this.list(wrapper);
        if(list!=null && list.size()>0){
            return BeanMapper.map(list.get(0), KeyanProjectVO.class);
        }
        return null;
    }

    @Override
    public void deleteDetailById(Long oldMainId) {
        QueryWrapper<KeyanProjectDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("pid", oldMainId);
        keyanProjectDetailMapper.delete(deleteWrapper);
    }

}
