/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sq.keyan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanMonographEntity;
import com.ejianc.business.sq.keyan.service.IKeyanMonographService;
import com.ejianc.business.sq.keyan.vo.KeyanMonographVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sq/keyan/monograph"})
public class KeyanMonographController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "zydxKeyanMonograph";
    @Autowired
    private IKeyanMonographService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KeyanMonographVO> saveOrUpdate(@RequestBody KeyanMonographVO saveOrUpdateVO) {
        KeyanMonographEntity entity = (KeyanMonographEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KeyanMonographEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        KeyanMonographVO vo = (KeyanMonographVO)((Object)BeanMapper.map((Object)((Object)entity), KeyanMonographVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KeyanMonographVO> queryDetail(Long id) {
        KeyanMonographEntity entity = (KeyanMonographEntity)((Object)this.service.selectById(id));
        KeyanMonographVO vo = (KeyanMonographVO)((Object)BeanMapper.map((Object)((Object)entity), KeyanMonographVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanMonographVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KeyanMonographVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("monographName");
        fuzzyFields.add("author");
        fuzzyFields.add("publisherName");
        fuzzyFields.add("isbnNo");
        fuzzyFields.add("cipNo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("unitId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanMonographVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/downTemplateUrl"})
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"sq/keyanMonograph-import.xlsx", (String)"\u4e13\u8457\u6a21\u677f");
    }

    @RequestMapping(value={"/importCheckData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();
        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<String>();
        fileds.addAll(Arrays.asList("unitName", "monographName", "publicationTime", "author", "countryInOut", "authorRank", "publisherName", "category", "isbnNo", "cipNo", "totalWordsNumber", "remarks"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<String>();
        filedsName.addAll(Arrays.asList("\u6240\u5c5e\u5355\u4f4d", "\u8457\u4f5c\u540d\u79f0", "\u51fa\u7248\u65f6\u95f4", "\u4f5c\u8005", "\u56fd\u5185/\u5916", "\u672c\u5355\u4f4d\u4f5c\u8005\u4f4d\u6b21", "\u51fa\u7248\u793e\u540d\u79f0", "\u7c7b\u522b", "ISBN\u53f7", "CIP\u6570\u636e\u53f7", "\u603b\u5b57\u6570", "\u5907\u6ce8"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        HashMap<String, JSONObject> filedsConfig = new HashMap<String, JSONObject>();
        JSONObject unitNameConfig = new JSONObject();
        unitNameConfig.put("org", (Object)"org");
        JSONObject unitNameMath = new JSONObject();
        unitNameMath.put("unitId", (Object)"id");
        unitNameConfig.put("fieldMath", (Object)unitNameMath);
        filedsConfig.put("unitName", unitNameConfig);
        importUtil.setFiledsConfig(filedsConfig);
        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanMonographVO");
        importUtil.setServiceName("keyanMonographService");
        ArrayList<String> requiredFields = new ArrayList<String>();
        requiredFields.addAll(Arrays.asList("unitName", "monographName", "publicationTime", "author", "countryInOut"));
        importUtil.setRequiredFields(requiredFields);
        importUtil.setiOrgApi(this.iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/importDataSave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanMonographVO> vos) {
        ArrayList<KeyanMonographEntity> entitys;
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid(), vos.size());
        if (billCode.isSuccess() && ((List)billCode.getData()).size() == vos.size()) {
            entitys = new ArrayList<KeyanMonographEntity>();
            for (int i = 0; i < vos.size(); ++i) {
                KeyanMonographEntity entity = (KeyanMonographEntity)((Object)BeanMapper.map((Object)((Object)vos.get(i)), KeyanMonographEntity.class));
                entity.setBillCode((String)((List)billCode.getData()).get(i));
                entitys.add(entity);
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdateBatch(entitys, entitys.size(), false);
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("monographName");
        fuzzyFields.add("author");
        fuzzyFields.add("publisherName");
        fuzzyFields.add("isbnNo");
        fuzzyFields.add("cipNo");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("unitId", new Parameter("in", commonOrgIds));
        }
        List list = this.service.queryList(param);
        List result = new ArrayList();
        if (list != null && list.size() > 0) {
            result = BeanMapper.mapList((Iterable)list, KeyanMonographVO.class);
        }
        HashMap beans = new HashMap();
        beans.put("records", result);
        ExcelExport.getInstance().exportWithTrans("sq/keyanMonograph-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refKeyanMonographData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<KeyanMonographVO>> refKeyanMonographData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanMonographVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

