package com.ejianc.business.prjdocs.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 考核项
 * 
 * @author generator
 * 
 */
public class PrjexecuteAssessmentItemVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private String assessmentItemName; // 考核项名称
    private String assessmentItemCategory; // 考核项类别
    private Long orgId; // 所属单位id
    private String orgName; // 所属单位
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate; // 编制时间
    private String remarks; // 备注
    
    private List<PrjexecuteAssessmentItemDetailVO> detailList = new ArrayList<>(); // 考核项明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getAssessmentItemName() {
        return assessmentItemName;
    }

    public void setAssessmentItemName(String assessmentItemName) {
        this.assessmentItemName = assessmentItemName;
    }
    public String getAssessmentItemCategory() {
        return assessmentItemCategory;
    }

    public void setAssessmentItemCategory(String assessmentItemCategory) {
        this.assessmentItemCategory = assessmentItemCategory;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<PrjexecuteAssessmentItemDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PrjexecuteAssessmentItemDetailVO> detailList) {
        this.detailList = detailList;
    }
}
