package com.ejianc.business.sq.keyan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 认定时间调整
 * 
 * @author generator
 * 
 */
public class KeyanRecognitionTimeAdjustmentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long sourceId; // 单据id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date oldTime; // 原认定时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date adjustmentTime; // 调整后认定时间
    private Long adjustmentUserId; // 调整人id
    private String adjustmentUserName; // 调整人

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Date getOldTime() {
        return oldTime;
    }

    public void setOldTime(Date oldTime) {
        this.oldTime = oldTime;
    }

    public Date getAdjustmentTime() {
        return adjustmentTime;
    }

    public void setAdjustmentTime(Date adjustmentTime) {
        this.adjustmentTime = adjustmentTime;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getAdjustmentUserId() {
        return adjustmentUserId;
    }

    @ReferDeserialTransfer
    public void setAdjustmentUserId(Long adjustmentUserId) {
        this.adjustmentUserId = adjustmentUserId;
    }

    public String getAdjustmentUserName() {
        return adjustmentUserName;
    }

    public void setAdjustmentUserName(String adjustmentUserName) {
        this.adjustmentUserName = adjustmentUserName;
    }
}
