/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjdocs.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prjdocs.bean.PrjexecuteAssessmentItemEntity;
import com.ejianc.business.prjdocs.mapper.PrjexecuteAssessmentItemMapper;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemDetailService;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemService;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemDetailVO;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prjexecuteAssessmentItemService")
public class PrjexecuteAssessmentItemServiceImpl
extends BaseServiceImpl<PrjexecuteAssessmentItemMapper, PrjexecuteAssessmentItemEntity>
implements IPrjexecuteAssessmentItemService {
    @Autowired
    private IPrjexecuteAssessmentItemDetailService detailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "zydxAssessmentItem";

    private static void sortIntMethod(List<PrjexecuteAssessmentItemDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                PrjexecuteAssessmentItemDetailVO o1Detail = (PrjexecuteAssessmentItemDetailVO)((Object)objectMapper.convertValue(o1, PrjexecuteAssessmentItemDetailVO.class));
                PrjexecuteAssessmentItemDetailVO o2Detail = (PrjexecuteAssessmentItemDetailVO)((Object)objectMapper.convertValue(o2, PrjexecuteAssessmentItemDetailVO.class));
                String[] strs1 = o1Detail.getSerialNumber().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getSerialNumber().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<PrjexecuteAssessmentItemDetailVO> createTreeData(List<PrjexecuteAssessmentItemDetailVO> list) {
        ArrayList<PrjexecuteAssessmentItemDetailVO> resp = new ArrayList<PrjexecuteAssessmentItemDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, PrjexecuteAssessmentItemDetailVO> listMap = new HashMap<String, PrjexecuteAssessmentItemDetailVO>();
        for (PrjexecuteAssessmentItemDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            PrjexecuteAssessmentItemDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            PrjexecuteAssessmentItemDetailVO parent = (PrjexecuteAssessmentItemDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<PrjexecuteAssessmentItemDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<PrjexecuteAssessmentItemDetailVO> children = new ArrayList<PrjexecuteAssessmentItemDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((PrjexecuteAssessmentItemDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @Override
    public PrjexecuteAssessmentItemVO queryDetail(Long id) {
        PrjexecuteAssessmentItemEntity entity = (PrjexecuteAssessmentItemEntity)((Object)this.selectById(id));
        PrjexecuteAssessmentItemVO vo = (PrjexecuteAssessmentItemVO)((Object)BeanMapper.map((Object)((Object)entity), PrjexecuteAssessmentItemVO.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("assessmentId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("serialNumber", "asc");
        List detailEntityList = this.detailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, PrjexecuteAssessmentItemDetailVO.class);
            PrjexecuteAssessmentItemServiceImpl.sortIntMethod(resultMapList);
            List<PrjexecuteAssessmentItemDetailVO> detailVOS = PrjexecuteAssessmentItemServiceImpl.createTreeData(resultMapList);
            vo.setDetailList(detailVOS);
        }
        return vo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PrjexecuteAssessmentItemVO saveData(PrjexecuteAssessmentItemVO saveOrUpdateVO) {
        PrjexecuteAssessmentItemEntity entity = (PrjexecuteAssessmentItemEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PrjexecuteAssessmentItemEntity.class));
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq((Object)"assessment_item_category", (Object)entity.getAssessmentItemCategory());
        checkWrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            checkWrapper.ne((Object)"id", (Object)entity.getId());
        }
        List check = this.list((Wrapper)checkWrapper);
        if (check.size() > 0) {
            throw new BusinessException("\u7ec4\u7ec7\u3010" + entity.getOrgName() + "\u3011\u4e0b\u5df2\u5b58\u5728\u3010" + entity.getAssessmentItemCategory() + "\u3011\u7c7b\u522b\u7684\u8003\u6838\u9879");
        }
        if (entity.getDetailList() != null && entity.getDetailList().size() > 0) {
            HashMap map = new HashMap();
            entity.getDetailList().forEach(item -> {
                if ("add".equals(item.getRowState())) {
                    item.setId(IdWorker.getId());
                    item.setAssessmentId(entity.getId());
                }
                if (!"del".equals(item.getRowState())) {
                    map.put(item.getSerialNumber(), item.getId());
                }
            });
            entity.getDetailList().forEach(item -> {
                if (item.getPid() != null && "add".equals(item.getRowState())) {
                    String code = item.getSerialNumber().substring(0, item.getSerialNumber().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
        }
        this.saveOrUpdate((Object)entity, false);
        PrjexecuteAssessmentItemVO vo = (PrjexecuteAssessmentItemVO)((Object)BeanMapper.map((Object)((Object)entity), PrjexecuteAssessmentItemVO.class));
        if (!CollectionUtils.isNotEmpty(vo.getDetailList())) return vo;
        PrjexecuteAssessmentItemServiceImpl.sortIntMethod(vo.getDetailList());
        List<PrjexecuteAssessmentItemDetailVO> detailVOS = PrjexecuteAssessmentItemServiceImpl.createTreeData(vo.getDetailList());
        vo.setDetailList(detailVOS);
        return vo;
    }
}

