package com.ejianc.business.zyscene.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zyscene.bean.SceneSafetyCheckCategoryEntity;
import com.ejianc.business.zyscene.mapper.SceneSafetyCheckCategoryMapper;
import com.ejianc.business.zyscene.service.ISceneSafetyCheckCategoryService;
import com.ejianc.business.zyscene.vo.SceneSafetyCheckCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 资源管理-安全检查分类表
 * 
 * @author generator
 * 
 */
@Service("sceneSafetyCheckCategoryService")
public class SceneSafetyCheckCategoryServiceImpl extends BaseServiceImpl<SceneSafetyCheckCategoryMapper, SceneSafetyCheckCategoryEntity> implements ISceneSafetyCheckCategoryService{

    @Autowired
    private SceneSafetyCheckCategoryMapper mapper;

    @Override
    public SceneSafetyCheckCategoryEntity queryByCode(String code) {
        QueryWrapper<SceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }

    @Override
    public List<SceneSafetyCheckCategoryEntity> queryListByPid(List<Long> ids) {
        QueryWrapper<SceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("parent_id", ids);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<SceneSafetyCheckCategoryEntity> queryByCodes(ArrayList<String> codes) {
        QueryWrapper<SceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("code", codes);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    @Override
    public List<SceneSafetyCheckCategoryVO> queryAllByPid(Long pid) {
        List<SceneSafetyCheckCategoryVO> resp = new ArrayList<>();
        SceneSafetyCheckCategoryEntity entity = super.selectById(pid);

        QueryWrapper<SceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.likeRight("inner_code", entity.getInnerCode());
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SceneSafetyCheckCategoryEntity> dataList = super.list(query);

        if(CollectionUtils.isNotEmpty(dataList)) {
            resp = BeanMapper.mapList(dataList, SceneSafetyCheckCategoryVO.class);
        }
        return resp;
    }

    @Override
    public List<SceneSafetyCheckCategoryVO> queryList(Map<String, Object> condition) {
        return mapper.queryList(condition);
    }
}
