package com.ejianc.business.prjdocs.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prjdocs.bean.PrjexecuteProcessInspectionEntity;
import com.ejianc.business.prjdocs.bean.PrjexecuteProcessInspectionItemEntity;
import com.ejianc.business.prjdocs.mapper.PrjexecuteProcessInspectionMapper;
import com.ejianc.business.prjdocs.service.IPrjexecuteProcessInspectionItemService;
import com.ejianc.business.prjdocs.service.IPrjexecuteProcessInspectionService;
import com.ejianc.business.prjdocs.vo.PrjexecuteProcessInspectionItemVO;
import com.ejianc.business.prjdocs.vo.PrjexecuteProcessInspectionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * 项目过程检查
 * 
 * @author generator
 * 
 */
@Service("prjexecuteProcessInspectionService")
public class PrjexecuteProcessInspectionServiceImpl extends BaseServiceImpl<PrjexecuteProcessInspectionMapper, PrjexecuteProcessInspectionEntity> implements IPrjexecuteProcessInspectionService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPrjexecuteProcessInspectionItemService itemService;

    private static final String BILL_CODE = "zydxProcessInspection";//此处需要根据实际修改

    private static void sortIntMethod(List<PrjexecuteProcessInspectionItemVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                PrjexecuteProcessInspectionItemVO o1Detail = objectMapper.convertValue(o1, PrjexecuteProcessInspectionItemVO.class);
                PrjexecuteProcessInspectionItemVO o2Detail = objectMapper.convertValue(o2, PrjexecuteProcessInspectionItemVO.class);
                String[] strs1 = o1Detail.getItemCode().split("\\.");
                String[] strs2 = o2Detail.getItemCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }
    @Override
    public PrjexecuteProcessInspectionVO saveData(PrjexecuteProcessInspectionVO saveOrUpdateVO) {
        PrjexecuteProcessInspectionEntity entity = BeanMapper.map(saveOrUpdateVO, PrjexecuteProcessInspectionEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        this.saveOrUpdate(entity, false);
        PrjexecuteProcessInspectionVO vo = BeanMapper.map(entity, PrjexecuteProcessInspectionVO.class);
        if (CollectionUtils.isNotEmpty(vo.getItemList())) {
            sortIntMethod(vo.getItemList());
        }
        return vo;
    }

    @Override
    public PrjexecuteProcessInspectionVO queryDetail(Long id) {
        PrjexecuteProcessInspectionEntity entity = this.selectById(id);
        PrjexecuteProcessInspectionVO vo = BeanMapper.map(entity, PrjexecuteProcessInspectionVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("inspectionId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("itemCode", "asc");
        List<PrjexecuteProcessInspectionItemEntity> detailEntityList = itemService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            List<PrjexecuteProcessInspectionItemVO> resultMapList = BeanMapper.mapList(detailEntityList, PrjexecuteProcessInspectionItemVO.class);
            sortIntMethod(resultMapList);
            vo.setItemList(resultMapList);
        }
        return vo;
    }
}
