package com.ejianc.business.prjdocs.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prjdocs.bean.PrjexecuteAssessmentItemDetailEntity;
import com.ejianc.business.prjdocs.bean.PrjexecuteAssessmentItemEntity;
import com.ejianc.business.prjdocs.mapper.PrjexecuteAssessmentItemMapper;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemDetailService;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemService;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemDetailVO;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 考核项
 * 
 * @author generator
 * 
 */
@Service("prjexecuteAssessmentItemService")
public class PrjexecuteAssessmentItemServiceImpl extends BaseServiceImpl<PrjexecuteAssessmentItemMapper, PrjexecuteAssessmentItemEntity> implements IPrjexecuteAssessmentItemService{

    @Autowired
    private IPrjexecuteAssessmentItemDetailService detailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "zydxAssessmentItem";//此处需要根据实际修改

    private static void sortIntMethod(List<PrjexecuteAssessmentItemDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                PrjexecuteAssessmentItemDetailVO o1Detail = objectMapper.convertValue(o1, PrjexecuteAssessmentItemDetailVO.class);
                PrjexecuteAssessmentItemDetailVO o2Detail = objectMapper.convertValue(o2, PrjexecuteAssessmentItemDetailVO.class);
                String[] strs1 = o1Detail.getSerialNumber().split("\\.");
                String[] strs2 = o2Detail.getSerialNumber().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<PrjexecuteAssessmentItemDetailVO> createTreeData(List<PrjexecuteAssessmentItemDetailVO> list) {
        List<PrjexecuteAssessmentItemDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, PrjexecuteAssessmentItemDetailVO> listMap = new HashMap<>();
        for(PrjexecuteAssessmentItemDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            PrjexecuteAssessmentItemDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            PrjexecuteAssessmentItemDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<PrjexecuteAssessmentItemDetailVO> child = (List<PrjexecuteAssessmentItemDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<PrjexecuteAssessmentItemDetailVO> children = new ArrayList<PrjexecuteAssessmentItemDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    @Override
    public PrjexecuteAssessmentItemVO queryDetail(Long id) {
        PrjexecuteAssessmentItemEntity entity = this.selectById(id);
        PrjexecuteAssessmentItemVO vo = BeanMapper.map(entity, PrjexecuteAssessmentItemVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("assessmentId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("serialNumber", "asc");
        List<PrjexecuteAssessmentItemDetailEntity> detailEntityList = detailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            List<PrjexecuteAssessmentItemDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, PrjexecuteAssessmentItemDetailVO.class);
            sortIntMethod(resultMapList);
            List<PrjexecuteAssessmentItemDetailVO> detailVOS = createTreeData(resultMapList);
            vo.setDetailList(detailVOS);
        }
        return vo;

    }

    @Override
    public PrjexecuteAssessmentItemVO saveData(PrjexecuteAssessmentItemVO saveOrUpdateVO) {
        PrjexecuteAssessmentItemEntity entity = BeanMapper.map(saveOrUpdateVO, PrjexecuteAssessmentItemEntity.class);
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq("assessment_item_category", entity.getAssessmentItemCategory());
        checkWrapper.eq("org_id", entity.getOrgId());
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else{
            checkWrapper.ne("id", entity.getId());
        }
        List check = this.list(checkWrapper);
        if(check.size()>0){
            throw new BusinessException("组织【"+entity.getOrgName()+"】下已存在【"+entity.getAssessmentItemCategory()+"】类别的考核项");
        }
        if(entity.getDetailList()!=null && entity.getDetailList().size()>0){
            Map<String, Long> map = new HashMap<>();
            entity.getDetailList().forEach(item -> {
                if("add".equals(item.getRowState())){
                    item.setId(IdWorker.getId());
                    item.setAssessmentId(entity.getId());
                }
                if(!"del".equals(item.getRowState())){
                    map.put(item.getSerialNumber(), item.getId());
                }
            });
            entity.getDetailList().forEach(item -> {
                if(item.getPid()!=null && "add".equals(item.getRowState())){
                    String code = item.getSerialNumber().substring(0, item.getSerialNumber().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
        }
        this.saveOrUpdate(entity, false);
        PrjexecuteAssessmentItemVO vo = BeanMapper.map(entity, PrjexecuteAssessmentItemVO.class);
        if (CollectionUtils.isNotEmpty(vo.getDetailList())) {
            sortIntMethod(vo.getDetailList());
            List<PrjexecuteAssessmentItemDetailVO> detailVOS = createTreeData(vo.getDetailList());
            vo.setDetailList(detailVOS);
        }
        return vo;
    }
}
