package com.ejianc.business.prjdocs.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投入资源需求计划
 * 
 * @author generator
 * 
 */
public class PrjInvestResourceRequirePlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 所属单位id
    private String orgName; // 所属单位名称
    private BigDecimal contractAmount; // 合同金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartDate; // 项目开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectEndDate; // 项目结束时间
    private String projectArea; // 项目地点
    private String workContent; // 工作内容
    private String workload; // 工作量
    private BigDecimal personSalary; // 人员工资
    private BigDecimal bonus; // 奖金
    private BigDecimal businessTravel; // 差旅应酬
    private BigDecimal projectMaterial; // 项目材料
    private BigDecimal otherExpense; // 其他费用
    private BigDecimal totalCost; // 总费用
    
    private List<PrjInvestResourceRequirePlanPersonVO> personList = new ArrayList<>(); // 投入资源需求计划--人员计划
    private List<PrjInvestResourceRequirePlanEquipmentVO> equipmentList = new ArrayList<>(); // 投入资源需求计划--设备计划

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }
    public Date getProjectEndDate() {
        return projectEndDate;
    }

    public void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }
    public String getProjectArea() {
        return projectArea;
    }

    public void setProjectArea(String projectArea) {
        this.projectArea = projectArea;
    }
    public String getWorkContent() {
        return workContent;
    }

    public void setWorkContent(String workContent) {
        this.workContent = workContent;
    }
    public String getWorkload() {
        return workload;
    }

    public void setWorkload(String workload) {
        this.workload = workload;
    }
    public BigDecimal getPersonSalary() {
        return personSalary;
    }

    public void setPersonSalary(BigDecimal personSalary) {
        this.personSalary = personSalary;
    }
    public BigDecimal getBonus() {
        return bonus;
    }

    public void setBonus(BigDecimal bonus) {
        this.bonus = bonus;
    }
    public BigDecimal getBusinessTravel() {
        return businessTravel;
    }

    public void setBusinessTravel(BigDecimal businessTravel) {
        this.businessTravel = businessTravel;
    }
    public BigDecimal getProjectMaterial() {
        return projectMaterial;
    }

    public void setProjectMaterial(BigDecimal projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    public BigDecimal getOtherExpense() {
        return otherExpense;
    }

    public void setOtherExpense(BigDecimal otherExpense) {
        this.otherExpense = otherExpense;
    }
    public BigDecimal getTotalCost() {
        return totalCost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public List<PrjInvestResourceRequirePlanPersonVO> getPersonList() {
        return personList;
    }

    public void setPersonList(List<PrjInvestResourceRequirePlanPersonVO> personList) {
        this.personList = personList;
    }

    public List<PrjInvestResourceRequirePlanEquipmentVO> getEquipmentList() {
        return equipmentList;
    }

    public void setEquipmentList(List<PrjInvestResourceRequirePlanEquipmentVO> equipmentList) {
        this.equipmentList = equipmentList;
    }
}
