package com.ejianc.business.safe.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 安全管理人员审查备案表
 * 
 * @author generator
 * 
 */
public class SafeMangerPersonCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据审批状态
    private String code; // 单据编码
    private Boolean belongProject; // 是否属于项目
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    private Long orgId; // 所属单位
    private String orgName; // 所属单位
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private Long processerId; // 经办人
    private String processerName; // 经办人
    private String memo; // 备注
    private String workExp; // 工作经历
    private String busiQuality; // 业务素质
    
    private List<SafeMangerPersonCheckSubVO> safeMangerPersonCheckSubList = new ArrayList<>(); // 安全管理人员审查备案表-子表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Boolean getBelongProject() {
        return belongProject;
    }

    public void setBelongProject(Boolean belongProject) {
        this.belongProject = belongProject;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    @ReferSerialTransfer(referCode="idm-employee,idm-user")
    public Long getProcesserId() {
        return processerId;
    }
    @ReferDeserialTransfer
    public void setProcesserId(Long processerId) {
        this.processerId = processerId;
    }
    public String getProcesserName() {
        return processerName;
    }

    public void setProcesserName(String processerName) {
        this.processerName = processerName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getWorkExp() {
        return workExp;
    }

    public void setWorkExp(String workExp) {
        this.workExp = workExp;
    }
    public String getBusiQuality() {
        return busiQuality;
    }

    public void setBusiQuality(String busiQuality) {
        this.busiQuality = busiQuality;
    }
    
     public List<SafeMangerPersonCheckSubVO> getSafeMangerPersonCheckSubList() {
        return safeMangerPersonCheckSubList;
     }

     public void setSafeMangerPersonCheckSubList(List<SafeMangerPersonCheckSubVO> safeMangerPersonCheckSubList) {
        this.safeMangerPersonCheckSubList = safeMangerPersonCheckSubList;
     }
}
