package com.ejianc.business.sq.keyan.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sq.keyan.bean.KeyanHighNewTechnologyEnterpriseEntity;
import com.ejianc.business.sq.keyan.bean.KeyanRecognitionTimeAdjustmentEntity;
import com.ejianc.business.sq.keyan.service.IKeyanHighNewTechnologyEnterpriseService;
import com.ejianc.business.sq.keyan.service.IKeyanRecognitionTimeAdjustmentService;
import com.ejianc.business.sq.keyan.vo.KeyanRecognitionTimeAdjustmentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 认定时间调整
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sq/keyan/recognitionTimeAdjustment")
public class KeyanRecognitionTimeAdjustmentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKeyanRecognitionTimeAdjustmentService service;
    @Autowired
    private IKeyanHighNewTechnologyEnterpriseService highNewTechnologyEnterpriseService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KeyanRecognitionTimeAdjustmentVO> saveOrUpdate(@RequestBody KeyanRecognitionTimeAdjustmentVO saveOrUpdateVO) {
        KeyanRecognitionTimeAdjustmentEntity entity = BeanMapper.map(saveOrUpdateVO, KeyanRecognitionTimeAdjustmentEntity.class);
        if(entity.getId()==null){
            KeyanHighNewTechnologyEnterpriseEntity en = highNewTechnologyEnterpriseService.selectById(saveOrUpdateVO.getSourceId());
            en.setRecognitionTime(saveOrUpdateVO.getAdjustmentTime());
            highNewTechnologyEnterpriseService.saveOrUpdate(en, false);
        }
    	service.saveOrUpdate(entity, false);
        KeyanRecognitionTimeAdjustmentVO vo = BeanMapper.map(entity, KeyanRecognitionTimeAdjustmentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KeyanRecognitionTimeAdjustmentVO> queryDetail(Long id) {
        KeyanRecognitionTimeAdjustmentEntity entity = service.selectById(id);
        KeyanRecognitionTimeAdjustmentVO vo = BeanMapper.map(entity, KeyanRecognitionTimeAdjustmentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryListBySourceId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KeyanRecognitionTimeAdjustmentVO>> queryListBySourceId(Long sourceId) {
        QueryWrapper<KeyanRecognitionTimeAdjustmentEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_id", sourceId);
        wrapper.orderByDesc("create_time");
        List<KeyanRecognitionTimeAdjustmentEntity> entitys = service.list(wrapper);
        List<KeyanRecognitionTimeAdjustmentVO> vos = BeanMapper.mapList(entitys, KeyanRecognitionTimeAdjustmentVO.class);
        return CommonResponse.success("查询详情数据成功！",vos);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanRecognitionTimeAdjustmentVO> vos) {
        service.removeByIds(vos.stream().map(KeyanRecognitionTimeAdjustmentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

}
