package com.ejianc.business.zyscene.service.impl;

import com.ejianc.business.zyscene.bean.SceneDailyEntity;
import com.ejianc.business.zyscene.mapper.SceneDailyMapper;
import com.ejianc.business.zyscene.service.CheckMessageService;
import com.ejianc.business.zyscene.service.ISceneDailyService;
import com.ejianc.business.zyscene.util.*;
import com.ejianc.business.zyscene.vo.SceneDailyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 日常检查主表
 * 
 * @author generator
 * 
 */
@Service("sceneDailyService")
public class SceneDailyServiceImpl extends BaseServiceImpl<SceneDailyMapper, SceneDailyEntity> implements ISceneDailyService{
    @Autowired
    private CheckMessageService checkMessageService;
    @Override
    public void checkSubmitHandle(Long billId) {
        if(billId != null){
            SceneDailyEntity sceneDailyEntity = this.selectById(billId);
            String notifRelevantId = sceneDailyEntity.getNotifRelevantId();
            SceneDailyVO vo = BeanMapper.map(sceneDailyEntity, SceneDailyVO.class);
            if(StringUtils.isNotBlank(notifRelevantId)){
                String[] notifRelevant = notifRelevantId.split(",");
                //发送消息给需要通知人员
                vo.setMsgNum(0);
                vo.setMsgBillCode(vo.getBillCode());
                vo.setMsgId(vo.getId());
                checkMessageService.sendDailyMsg(vo,notifRelevant,NoticeEnum.CHECK_Detail_COMMIT_PASS_REVIEW);
            }


        }
    }
}
