package com.ejianc.business.zyscene.util;

import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 微信公众号消息类型
 * @date 2021/10/20
 */
public enum NoticeEnum {

    /**
     * 检查单审批
     * 通过
     * 整改责任人，相关人员
     */
    CHECK_COMMIT_PASS("检查单审批通知整改人", "现场检查整改通知", "请及时整改"),

    CHECK_COMMIT_PASS_REVIEW("检查单审批通知相关人", "现场检查通知", "请及时查看"),
    CHECK_Detail_COMMIT_PASS_REVIEW("日常检查审批通知相关人", "日常检查通知", "请及时查看"),

    /**
     * 整改任务全部提交
     * 复查人
     */
    REFORM_COMMIT("整改任务对应复查人员", "现场检查复查通知", "请及时复查"),

    REVIEW_COMMIT_UNPASS("复查提交（含有不合格）", "现场检查整改通知", "请及时整改"),

    REVIEW_COMMIT_PASS("复查提交（全部合格）", "现场检查通知", "请及时查看"),

    REFORM_OVERTIME("整改逾期提醒", "现场检查整改逾期提醒", "请及时整改"),

    REVIEW_OVERTIME("复查逾期提醒", "现场检查复查逾期提醒", "请及时复查");

    private String desc;

    private String subject;

    private String key1;


    private static Map<NoticeEnum, String> mobileContentMap = new HashMap<>();

    private static Map<NoticeEnum, String> mobileUrlMap = new HashMap<>();

    private static Map<NoticeEnum, String> pcContentMap = new HashMap<>();


    static {
        mobileContentMap.put(CHECK_COMMIT_PASS, "你有 #NUM# 条新的整改任务需要处理，检查单【#CHECKNAME#】，点击查看详情");
        mobileUrlMap.put(CHECK_COMMIT_PASS, "#BASEHOST#ejc-scene-mobile/#/rectification");
        pcContentMap.put(CHECK_COMMIT_PASS, "你有 #NUM# 条新的整改任务需要处理，检查单【#CHECKNAME#】<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/reform" + '"' + ">点击查看详情</a>");

        mobileContentMap.put(CHECK_COMMIT_PASS_REVIEW, "收到编号为【#BILLCODE#】的检查单，请及时安排相关人员处理，点击查看详情");
        mobileUrlMap.put(CHECK_COMMIT_PASS_REVIEW, "#BASEHOST#ejc-scene-mobile/#/check/card?id=#ID#");
        pcContentMap.put(CHECK_COMMIT_PASS_REVIEW, "收到编号为【#BILLCODE#】的检查单，请及时安排相关人员处理，<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/check/card?id=#ID#" + '"' + ">点击查看详情</a>");

        mobileContentMap.put(CHECK_Detail_COMMIT_PASS_REVIEW, "收到编号为【#BILLCODE#】的日常检查单，请及时安排相关人员处理，点击查看详情");
        mobileUrlMap.put(CHECK_Detail_COMMIT_PASS_REVIEW, "#BASEHOST#ejc-scene-mobile/#/daily/card?id=#ID#");
        pcContentMap.put(CHECK_Detail_COMMIT_PASS_REVIEW, "收到编号为【#BILLCODE#】的日常检查单，请及时安排相关人员处理，<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/daily/card?id=#ID#" + '"' + ">点击查看详情</a>");

        mobileContentMap.put(REFORM_COMMIT, "收到编号为【#BILLCODE#】的复查单，请及时处理，点击查看详情");
        mobileUrlMap.put(REFORM_COMMIT, "#BASEHOST#ejc-scene-mobile/#/review/card?id=#ID#");
        pcContentMap.put(REFORM_COMMIT, "收到编号为【#BILLCODE#】的复查单，请及时处理，<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/review/card?id=#ID#" + '"' + ">点击查看详情</a>");

        mobileContentMap.put(REVIEW_COMMIT_UNPASS, "你有 #NUM# 条新的整改任务需要处理，检查单【#CHECKNAME#】，点击查看详情");
        mobileUrlMap.put(REVIEW_COMMIT_UNPASS, "#BASEHOST#ejc-scene-mobile/#/rectification");
        pcContentMap.put(REVIEW_COMMIT_UNPASS, "你有 #NUM# 条新的整改任务需要处理，检查单【#CHECKNAME#】<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/reform" + '"' + ">点击查看详情</a>");

        mobileContentMap.put(REVIEW_COMMIT_PASS, "收到编号为【#BILLCODE#】的检查单，请及时处理，点击查看详情");
        mobileUrlMap.put(REVIEW_COMMIT_PASS, "#BASEHOST#ejc-scene-mobile/#/inspectResult/card?id=#ID#");
        pcContentMap.put(REVIEW_COMMIT_PASS, "收到编号为【#BILLCODE#】的检查单，请及时处理，<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/checkResult/card?id=#ID#" + '"' + ">点击查看详情</a>");

        mobileContentMap.put(REFORM_OVERTIME, "你有 #NUM# 条整改任务即将逾期，请及时处理，点击查看详情");
        mobileUrlMap.put(REFORM_OVERTIME, "#BASEHOST#ejc-scene-mobile/#/rectification");
        pcContentMap.put(REFORM_OVERTIME, "你有 #NUM# 条整改任务即将逾期，请及时处理，<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/reform" + '"' + ">点击查看详情</a>");

        mobileContentMap.put(REVIEW_OVERTIME, "你有 #NUM# 条复查任务即将逾期，请及时处理，点击查看详情");
        mobileUrlMap.put(REVIEW_OVERTIME, "#BASEHOST#ejc-scene-mobile/#/review");
        pcContentMap.put(REVIEW_OVERTIME, "你有 #NUM# 条复查任务即将逾期，请及时处理，<a href=" + '"' + "#BASEHOST#ejc-scene-frontend/#/review" + '"' + ">点击查看详情</a>");


    }

    NoticeEnum(String desc, String subject, String key1) {
        this.desc = desc;
        this.subject = subject;
        this.key1 = key1;
    }

    public static String getMobileUrl(NoticeEnum notice, Map<String, String> map) {

        String url = mobileUrlMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url.contains("?") ? url + "&" : url + "?";
    }

    public static String getMobileContent(NoticeEnum notice, HashMap<String, String> map) {
        String url = mobileContentMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url;
    }


    public static String getPcContent(NoticeEnum notice, HashMap<String, String> map) {
        String url = pcContentMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url;
    }


    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }


    public String getKey1() {
        return key1;
    }

    public void setKey1(String key1) {
        this.key1 = key1;
    }


}
