package com.ejianc.business.zyscene.util;

import com.ejianc.framework.core.response.BillStateEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author
 * @Date
 * @Description
 */

public enum ReformState {
    INITIAL_STATE("0","初始状态"),
    REFORM_STATE("1","整改状态"),
    REVIEW_STATE("2","待复查"),
    REVIEW_FAILED_STATE("3","复查不合格"),
    REVIEW_FINISHED_STATE("4","已完成");


    private String code;

    private String description;

    private static Map<Integer, BillStateEnum> enumMap = new HashMap<>();
    //构造方法
    private ReformState(String code, String description ){
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    static {
        enumMap = EnumSet.allOf(BillStateEnum.class).stream().collect(Collectors.toMap(BillStateEnum::getBillStateCode, Function.identity(), (k1, k2) -> k2));
    }

    public static BillStateEnum getEnumByStateCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
