package com.ejianc.business.prjdocs.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目完工考核
 * 
 * @author generator
 * 
 */
public class PrjCompletionAssessmentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 所属单位id
    private String orgName; // 所属单位名称
    private Long projectLeaderUserId; // 被考核项目负责人id
    private String projectLeaderUserName; // 被考核项目负责人
    private Long inspectionMemberUserId; // 检查组成员id
    private String inspectionMemberUserName; // 检查组成员
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inspectionDate; // 检查日期
    private BigDecimal checkScore; // 检查得分
    private String remarks; // 备注
    
    private List<PrjCompletionAssessmentItemVO> itemList = new ArrayList<>(); // 项目完工考核项

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectLeaderUserId() {
        return projectLeaderUserId;
    }

    @ReferDeserialTransfer
    public void setProjectLeaderUserId(Long projectLeaderUserId) {
        this.projectLeaderUserId = projectLeaderUserId;
    }
    public String getProjectLeaderUserName() {
        return projectLeaderUserName;
    }

    public void setProjectLeaderUserName(String projectLeaderUserName) {
        this.projectLeaderUserName = projectLeaderUserName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getInspectionMemberUserId() {
        return inspectionMemberUserId;
    }

    @ReferDeserialTransfer
    public void setInspectionMemberUserId(Long inspectionMemberUserId) {
        this.inspectionMemberUserId = inspectionMemberUserId;
    }
    public String getInspectionMemberUserName() {
        return inspectionMemberUserName;
    }

    public void setInspectionMemberUserName(String inspectionMemberUserName) {
        this.inspectionMemberUserName = inspectionMemberUserName;
    }
    public Date getInspectionDate() {
        return inspectionDate;
    }

    public void setInspectionDate(Date inspectionDate) {
        this.inspectionDate = inspectionDate;
    }
    public BigDecimal getCheckScore() {
        return checkScore;
    }

    public void setCheckScore(BigDecimal checkScore) {
        this.checkScore = checkScore;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<PrjCompletionAssessmentItemVO> getItemList() {
        return itemList;
    }

    public void setItemList(List<PrjCompletionAssessmentItemVO> itemList) {
        this.itemList = itemList;
    }
}
