package com.ejianc.business.sq.keyan.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.sq.keyan.bean.KeyanProjectEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.vo.KeyanProjectChangeVO;
import com.ejianc.business.sq.keyan.vo.KeyanProjectDetailChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sq.keyan.mapper.KeyanProjectChangeMapper;
import com.ejianc.business.sq.keyan.bean.KeyanProjectChangeEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectChangeService;

import java.util.Date;
import java.util.List;

/**
 * 在研项目立项变更
 * 
 * @author generator
 * 
 */
@Service("keyanProjectChangeService")
public class KeyanProjectChangeServiceImpl extends BaseServiceImpl<KeyanProjectChangeMapper, KeyanProjectChangeEntity> implements IKeyanProjectChangeService{
    @Autowired
    private IKeyanProjectService keyanProjectService;
    @Autowired
    private IKeyanProjectChangeService servicee;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public KeyanProjectChangeVO addConvertByMainId(Long mainId) {
        KeyanProjectEntity keyanProjectEntity = keyanProjectService.selectById(mainId);
        KeyanProjectChangeVO changeVO = BeanMapper.map(keyanProjectEntity, KeyanProjectChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setOldMainId(changeVO.getId());
        changeVO.setChangeVersion(keyanProjectEntity.getChangeVersion() == null ? 1 : keyanProjectEntity.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(IdWorker.getId());

        List<KeyanProjectDetailChangeVO> changeDetailList = changeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setOldDetailId(changeDetailVO.getId());
                changeDetailVO.setRowState("edit");
            });
        }


        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(mainId),"EJCBT202412000003","projectProposal",
                String.valueOf(changeVO.getId()), "EJCBT202505000001","projectProposal");
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(mainId),"EJCBT202412000003","feasibleReport",
                String.valueOf(changeVO.getId()), "EJCBT202505000001","feasibleReport");
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(mainId),"EJCBT202412000003","budgetSheet",
                String.valueOf(changeVO.getId()), "EJCBT202505000001","budgetSheet");
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(mainId),"EJCBT202412000003","internalArgumentationOpinion",
                String.valueOf(changeVO.getId()), "EJCBT202505000001","internalArgumentationOpinion");
        return changeVO;
    }
}
