package com.ejianc.business.zjkjcost.manage.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 项目目标管理责任书
 * 
 * @author generator
 * 
 */
@ApiModel("项目目标管理责任书")
public class BookVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目部id")
    private Long orgId;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("工程地点")
    private String projectLocation;
    @ApiModelProperty("建筑面积")
    private BigDecimal builtArea;
    @ApiModelProperty("结构形式")
    private String structuralStyle;
    @ApiModelProperty("项目规模")
    private String projectScale;
    @ApiModelProperty("计价方式")
    private String priceMethod;
    @ApiModelProperty("质量标准")
    private String qualityStandard;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("开工日期")
    private Date startDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("竣工日期")
    private Date endDate;
    @ApiModelProperty("总包合同额")
    private BigDecimal zbContractMny;
    @ApiModelProperty("自施合同额")
    private BigDecimal zsContractMny;
    @ApiModelProperty("其他合同额(集成)")
    private BigDecimal otherContractMny;
    @ApiModelProperty("委托人")
    private String client;
    @ApiModelProperty("受托人")
    private String trustee;
    @ApiModelProperty("合同总工期")
    private Integer duration;
    @ApiModelProperty("合同类别")
    private Long contractCategoryId;
    @ApiModelProperty("合同类别名称")
    private String contractCategoryName;
    @ApiModelProperty("工程质量")
    private String constructionQuality;
    @ApiModelProperty("安全生产")
    private String safetyProduction;
    @ApiModelProperty("IC形象")
    private BigDecimal icImage;
    @ApiModelProperty("上缴款")
    private BigDecimal upPayment;
    @ApiModelProperty("风险金预留")
    private BigDecimal riskFund;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("上缴基数(不含税收入)")
    private BigDecimal turninBase;
    @ApiModelProperty("责任成本(不含税成本)")
    private BigDecimal responsibilityCost;
    @ApiModelProperty("整体上缴比例(B值)")
    private BigDecimal allScale;
    @ApiModelProperty("上缴金额(暂定，随结算金额调整)")
    private BigDecimal amountPaid;
    @ApiModelProperty("标前(A值)(承接利润率)")
    private BigDecimal preBid;
    @ApiModelProperty("备注")
    private String memo;
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目部id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 工程地点
     */
    public String getProjectLocation() {
        return projectLocation;
    }

    /**
     * 工程地点
     */
    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }
    /**
     * 建筑面积
     */
    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    /**
     * 建筑面积
     */
    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    /**
     * 结构形式
     */
    public String getStructuralStyle() {
        return structuralStyle;
    }

    /**
     * 结构形式
     */
    public void setStructuralStyle(String structuralStyle) {
        this.structuralStyle = structuralStyle;
    }
    /**
     * 项目规模
     */
    public String getProjectScale() {
        return projectScale;
    }

    /**
     * 项目规模
     */
    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }
    /**
     * 计价方式
     */
    public String getPriceMethod() {
        return priceMethod;
    }

    /**
     * 计价方式
     */
    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
    }
    /**
     * 质量标准
     */
    public String getQualityStandard() {
        return qualityStandard;
    }

    /**
     * 质量标准
     */
    public void setQualityStandard(String qualityStandard) {
        this.qualityStandard = qualityStandard;
    }
    /**
     * 开工日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 开工日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 竣工日期
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * 竣工日期
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 总包合同额
     */
    public BigDecimal getZbContractMny() {
        return zbContractMny;
    }

    /**
     * 总包合同额
     */
    public void setZbContractMny(BigDecimal zbContractMny) {
        this.zbContractMny = zbContractMny;
    }
    /**
     * 自施合同额
     */
    public BigDecimal getZsContractMny() {
        return zsContractMny;
    }

    /**
     * 自施合同额
     */
    public void setZsContractMny(BigDecimal zsContractMny) {
        this.zsContractMny = zsContractMny;
    }
    /**
     * 其他合同额(集成)
     */
    public BigDecimal getOtherContractMny() {
        return otherContractMny;
    }

    /**
     * 其他合同额(集成)
     */
    public void setOtherContractMny(BigDecimal otherContractMny) {
        this.otherContractMny = otherContractMny;
    }
    /**
     * 委托人
     */
    public String getClient() {
        return client;
    }

    /**
     * 委托人
     */
    public void setClient(String client) {
        this.client = client;
    }
    /**
     * 受托人
     */
    public String getTrustee() {
        return trustee;
    }

    /**
     * 受托人
     */
    public void setTrustee(String trustee) {
        this.trustee = trustee;
    }
    /**
     * 合同总工期
     */
    public Integer getDuration() {
        return duration;
    }

    /**
     * 合同总工期
     */
    public void setDuration(Integer duration) {
        this.duration = duration;
    }
    /**
     * 合同类别
     */
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    /**
     * 合同类别
     */
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    /**
     * 合同类别名称
     */
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    /**
     * 合同类别名称
     */
    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    /**
     * 工程质量
     */
    public String getConstructionQuality() {
        return constructionQuality;
    }

    /**
     * 工程质量
     */
    public void setConstructionQuality(String constructionQuality) {
        this.constructionQuality = constructionQuality;
    }
    /**
     * 安全生产
     */
    public String getSafetyProduction() {
        return safetyProduction;
    }

    /**
     * 安全生产
     */
    public void setSafetyProduction(String safetyProduction) {
        this.safetyProduction = safetyProduction;
    }
    /**
     * IC形象
     */
    public BigDecimal getIcImage() {
        return icImage;
    }

    /**
     * IC形象
     */
    public void setIcImage(BigDecimal icImage) {
        this.icImage = icImage;
    }
    /**
     * 上缴款
     */
    public BigDecimal getUpPayment() {
        return upPayment;
    }

    /**
     * 上缴款
     */
    public void setUpPayment(BigDecimal upPayment) {
        this.upPayment = upPayment;
    }
    /**
     * 风险金预留
     */
    public BigDecimal getRiskFund() {
        return riskFund;
    }

    /**
     * 风险金预留
     */
    public void setRiskFund(BigDecimal riskFund) {
        this.riskFund = riskFund;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 上缴基数(不含税收入)
     */
    public BigDecimal getTurninBase() {
        return turninBase;
    }

    /**
     * 上缴基数(不含税收入)
     */
    public void setTurninBase(BigDecimal turninBase) {
        this.turninBase = turninBase;
    }
    /**
     * 责任成本(不含税成本)
     */
    public BigDecimal getResponsibilityCost() {
        return responsibilityCost;
    }

    /**
     * 责任成本(不含税成本)
     */
    public void setResponsibilityCost(BigDecimal responsibilityCost) {
        this.responsibilityCost = responsibilityCost;
    }
    /**
     * 整体上缴比例(B值)
     */
    public BigDecimal getAllScale() {
        return allScale;
    }

    /**
     * 整体上缴比例(B值)
     */
    public void setAllScale(BigDecimal allScale) {
        this.allScale = allScale;
    }
    /**
     * 上缴金额(暂定，随结算金额调整)
     */
    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    /**
     * 上缴金额(暂定，随结算金额调整)
     */
    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }
    /**
     * 标前(A值)(承接利润率)
     */
    public BigDecimal getPreBid() {
        return preBid;
    }

    /**
     * 标前(A值)(承接利润率)
     */
    public void setPreBid(BigDecimal preBid) {
        this.preBid = preBid;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
