package com.ejianc.business.zjkjcost.reserve.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 风险预留金-项目部人员风险金预留分配变更子表
 * 
 * @author generator
 * 
 */
@ApiModel("风险预留金-项目部人员风险金预留分配变更子表")
public class AllocateChangeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("主表主键ID")
    private Long allocateId;
    @ApiModelProperty("人员ID")
    private Long personnelId;
    @ApiModelProperty("人员名称")
    private String personnelName;
    @ApiModelProperty("人员编号")
    private String personnelCode;
    @ApiModelProperty("岗位职务")
    private String postName;
    @ApiModelProperty("应预留风险金额")
    private BigDecimal shouldDetailMny;
    @ApiModelProperty("实际预留风险金额")
    private BigDecimal actualDetailMny;
    @ApiModelProperty("预留风险比例")
    private BigDecimal detailRatio;
    @ApiModelProperty("变更前应预留风险金额")
    private BigDecimal beforeShouldDetailMny;
    @ApiModelProperty("变更前实际预留风险金额")
    private BigDecimal beforeActualDetailMny;
    @ApiModelProperty("变更前预留风险比例")
    private BigDecimal beforeDetailRatio;
    @ApiModelProperty("变更类型:0-未变更 1-增补项，2-删除项，3-变更项")
    private Integer changeType;
    @ApiModelProperty("变更项原数据Id")
    private Long targetDetailId;
    @ApiModelProperty("变更前附件id集合串")
    private String beforeFileIds;
    @ApiModelProperty("附件id集合串")
    private String fileIds;
    @ApiModelProperty("返还、转抵、离退id集合串")
    private String fhzdltIds;
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 主表主键ID
     */
    public Long getAllocateId() {
        return allocateId;
    }

    /**
     * 主表主键ID
     */
    public void setAllocateId(Long allocateId) {
        this.allocateId = allocateId;
    }
    /**
     * 人员ID
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getPersonnelId() {
        return personnelId;
    }

    /**
     * 人员ID
     */
    @ReferDeserialTransfer
    public void setPersonnelId(Long personnelId) {
        this.personnelId = personnelId;
    }
    /**
     * 人员名称
     */
    public String getPersonnelName() {
        return personnelName;
    }

    /**
     * 人员名称
     */
    public void setPersonnelName(String personnelName) {
        this.personnelName = personnelName;
    }
    /**
     * 人员编号
     */
    public String getPersonnelCode() {
        return personnelCode;
    }

    /**
     * 人员编号
     */
    public void setPersonnelCode(String personnelCode) {
        this.personnelCode = personnelCode;
    }
    /**
     * 岗位职务
     */
    public String getPostName() {
        return postName;
    }

    /**
     * 岗位职务
     */
    public void setPostName(String postName) {
        this.postName = postName;
    }
    /**
     * 应预留风险金额
     */
    public BigDecimal getShouldDetailMny() {
        return shouldDetailMny;
    }

    /**
     * 应预留风险金额
     */
    public void setShouldDetailMny(BigDecimal shouldDetailMny) {
        this.shouldDetailMny = shouldDetailMny;
    }
    /**
     * 实际预留风险金额
     */
    public BigDecimal getActualDetailMny() {
        return actualDetailMny;
    }

    /**
     * 实际预留风险金额
     */
    public void setActualDetailMny(BigDecimal actualDetailMny) {
        this.actualDetailMny = actualDetailMny;
    }
    /**
     * 预留风险比例
     */
    public BigDecimal getDetailRatio() {
        return detailRatio;
    }

    /**
     * 预留风险比例
     */
    public void setDetailRatio(BigDecimal detailRatio) {
        this.detailRatio = detailRatio;
    }
    /**
     * 变更前应预留风险金额
     */
    public BigDecimal getBeforeShouldDetailMny() {
        return beforeShouldDetailMny;
    }

    /**
     * 变更前应预留风险金额
     */
    public void setBeforeShouldDetailMny(BigDecimal beforeShouldDetailMny) {
        this.beforeShouldDetailMny = beforeShouldDetailMny;
    }
    /**
     * 变更前实际预留风险金额
     */
    public BigDecimal getBeforeActualDetailMny() {
        return beforeActualDetailMny;
    }

    /**
     * 变更前实际预留风险金额
     */
    public void setBeforeActualDetailMny(BigDecimal beforeActualDetailMny) {
        this.beforeActualDetailMny = beforeActualDetailMny;
    }
    /**
     * 变更前预留风险比例
     */
    public BigDecimal getBeforeDetailRatio() {
        return beforeDetailRatio;
    }

    /**
     * 变更前预留风险比例
     */
    public void setBeforeDetailRatio(BigDecimal beforeDetailRatio) {
        this.beforeDetailRatio = beforeDetailRatio;
    }
    /**
     * 变更类型:0-未变更 1-增补项，2-删除项，3-变更项
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型:0-未变更 1-增补项，2-删除项，3-变更项
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    /**
     * 变更项原数据Id
     */
    public Long getTargetDetailId() {
        return targetDetailId;
    }

    /**
     * 变更项原数据Id
     */
    public void setTargetDetailId(Long targetDetailId) {
        this.targetDetailId = targetDetailId;
    }
    /**
     * 变更前附件id集合串
     */
    public String getBeforeFileIds() {
        return beforeFileIds;
    }

    /**
     * 变更前附件id集合串
     */
    public void setBeforeFileIds(String beforeFileIds) {
        this.beforeFileIds = beforeFileIds;
    }
    /**
     * 附件id集合串
     */
    public String getFileIds() {
        return fileIds;
    }

    /**
     * 附件id集合串
     */
    public void setFileIds(String fileIds) {
        this.fileIds = fileIds;
    }
    /**
     * 返还、转抵、离退id集合串
     */
    public String getFhzdltIds() {
        return fhzdltIds;
    }

    /**
     * 返还、转抵、离退id集合串
     */
    public void setFhzdltIds(String fhzdltIds) {
        this.fhzdltIds = fhzdltIds;
    }
    
}
