package com.ejianc.business.zjkjcost.reserve.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 风险预留金-项目部预留金返还审批表
 * 
 * @author generator
 * 
 */
@ApiModel("风险预留金-项目部预留金返还审批表")
public class DepartmentApproveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("项目部")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("组织")
    private Long parentOrgId;
    @ApiModelProperty("组织名称")
    private String parentOrgName;
    @ApiModelProperty("组织组织编码")
    private String parentOrgCode;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办时间")
    private Date employeeTime;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("预留风险金额")
    private BigDecimal reserveMny;
    @ApiModelProperty("申请预留返还比例(项目部)")
    private BigDecimal applyRestitutionRatio;
    @ApiModelProperty("具体事项(项目部)")
    private String specificClause;
    @ApiModelProperty("预留风险金核定总额（财务部）")
    private BigDecimal verifyTotalMny;
    @ApiModelProperty("实际预留风险金额(财务部)")
    private BigDecimal actualReserveMny;
    @ApiModelProperty("返还金额(财务部)")
    private BigDecimal financeRestitutionMny;
    @ApiModelProperty("建议返还预留比例(商务部)")
    private BigDecimal businessRestitutionRatio;
    @ApiModelProperty("建议返还预留金额(商务部)")
    private BigDecimal businessRestitutionMny;
    @ApiModelProperty("返还金额(经济部)")
    private BigDecimal economyRestitutionMny;
    @ApiModelProperty("返还金额(总经理)")
    private BigDecimal generalRestitutionMny;
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目部
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 组织组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 组织组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办时间
     */
    public Date getEmployeeTime() {
        return employeeTime;
    }

    /**
     * 经办时间
     */
    public void setEmployeeTime(Date employeeTime) {
        this.employeeTime = employeeTime;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 预留风险金额
     */
    public BigDecimal getReserveMny() {
        return reserveMny;
    }

    /**
     * 预留风险金额
     */
    public void setReserveMny(BigDecimal reserveMny) {
        this.reserveMny = reserveMny;
    }
    /**
     * 申请预留返还比例(项目部)
     */
    public BigDecimal getApplyRestitutionRatio() {
        return applyRestitutionRatio;
    }

    /**
     * 申请预留返还比例(项目部)
     */
    public void setApplyRestitutionRatio(BigDecimal applyRestitutionRatio) {
        this.applyRestitutionRatio = applyRestitutionRatio;
    }
    /**
     * 具体事项(项目部)
     */
    public String getSpecificClause() {
        return specificClause;
    }

    /**
     * 具体事项(项目部)
     */
    public void setSpecificClause(String specificClause) {
        this.specificClause = specificClause;
    }
    /**
     * 预留风险金核定总额（财务部）
     */
    public BigDecimal getVerifyTotalMny() {
        return verifyTotalMny;
    }

    /**
     * 预留风险金核定总额（财务部）
     */
    public void setVerifyTotalMny(BigDecimal verifyTotalMny) {
        this.verifyTotalMny = verifyTotalMny;
    }
    /**
     * 实际预留风险金额(财务部)
     */
    public BigDecimal getActualReserveMny() {
        return actualReserveMny;
    }

    /**
     * 实际预留风险金额(财务部)
     */
    public void setActualReserveMny(BigDecimal actualReserveMny) {
        this.actualReserveMny = actualReserveMny;
    }
    /**
     * 返还金额(财务部)
     */
    public BigDecimal getFinanceRestitutionMny() {
        return financeRestitutionMny;
    }

    /**
     * 返还金额(财务部)
     */
    public void setFinanceRestitutionMny(BigDecimal financeRestitutionMny) {
        this.financeRestitutionMny = financeRestitutionMny;
    }
    /**
     * 建议返还预留比例(商务部)
     */
    public BigDecimal getBusinessRestitutionRatio() {
        return businessRestitutionRatio;
    }

    /**
     * 建议返还预留比例(商务部)
     */
    public void setBusinessRestitutionRatio(BigDecimal businessRestitutionRatio) {
        this.businessRestitutionRatio = businessRestitutionRatio;
    }
    /**
     * 建议返还预留金额(商务部)
     */
    public BigDecimal getBusinessRestitutionMny() {
        return businessRestitutionMny;
    }

    /**
     * 建议返还预留金额(商务部)
     */
    public void setBusinessRestitutionMny(BigDecimal businessRestitutionMny) {
        this.businessRestitutionMny = businessRestitutionMny;
    }
    /**
     * 返还金额(经济部)
     */
    public BigDecimal getEconomyRestitutionMny() {
        return economyRestitutionMny;
    }

    /**
     * 返还金额(经济部)
     */
    public void setEconomyRestitutionMny(BigDecimal economyRestitutionMny) {
        this.economyRestitutionMny = economyRestitutionMny;
    }
    /**
     * 返还金额(总经理)
     */
    public BigDecimal getGeneralRestitutionMny() {
        return generalRestitutionMny;
    }

    /**
     * 返还金额(总经理)
     */
    public void setGeneralRestitutionMny(BigDecimal generalRestitutionMny) {
        this.generalRestitutionMny = generalRestitutionMny;
    }
    
}
