package com.ejianc.business.zjkjcost.optimization.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 项目优化-项目优化立项申报
 * 
 * @author generator
 * 
 */
@ApiModel("项目优化-项目优化立项申报")
public class OptimizationTopicVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("立项名称")
    private String topicName;
    @ApiModelProperty("计划实施开始日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planTermStart;
    @ApiModelProperty("计划实施结束日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planTermEnd;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("实施人员")
    private String topicExecUser;
    @ApiModelProperty("优化方案简要内容")
    private String briefScheme;
    @ApiModelProperty("预计收益及测算依据")
    private String incomeBasis;
    @ApiModelProperty("项目经理意见")
    private String managerOpinion;
    @ApiModelProperty("所属单位归口管理部门是否同意立项(0:同意，1:不同意)")
    private Integer departmentConsentFlag;
    @ApiModelProperty("所属单位归口管理部门指导意见")
    private String departmentOpinion;
    @ApiModelProperty("所属单位归口管理部门分管领导是否同意立项(0:同意，1:不同意)")
    private Integer leaderConsentFlag;
    @ApiModelProperty("所属单位归口管理部门分管领导指导意见")
    private String leaderOpinion;
    @ApiModelProperty("项目优化效益计算占用标志(0:未占用，1:已占用)")
    private Integer calculationOccupyFlag;
    @ApiModelProperty("项目优化奖励申请占用标志(0:未占用，1:已占用)")
    private Integer rewardOccupyFlag;

    @ApiModelProperty("预计效益金额")
    private BigDecimal benefitMny;
    @ApiModelProperty("立项类型ID")
    private Long topicTypeId;
    @ApiModelProperty("立项类型名称")
    private String topicTypeName;

    private String billStateName;

    public BigDecimal getBenefitMny() {
        return benefitMny;
    }

    public void setBenefitMny(BigDecimal benefitMny) {
        this.benefitMny = benefitMny;
    }

    public Long getTopicTypeId() {
        return topicTypeId;
    }

    public void setTopicTypeId(Long topicTypeId) {
        this.topicTypeId = topicTypeId;
    }

    public String getTopicTypeName() {
        return topicTypeName;
    }

    public void setTopicTypeName(String topicTypeName) {
        this.topicTypeName = topicTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 立项名称
     */
    public String getTopicName() {
        return topicName;
    }

    /**
     * 立项名称
     */
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public Date getPlanTermStart() {
        return planTermStart;
    }

    public void setPlanTermStart(Date planTermStart) {
        this.planTermStart = planTermStart;
    }

    public Date getPlanTermEnd() {
        return planTermEnd;
    }

    public void setPlanTermEnd(Date planTermEnd) {
        this.planTermEnd = planTermEnd;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 实施人员
     */
    public String getTopicExecUser() {
        return topicExecUser;
    }

    /**
     * 实施人员
     */
    public void setTopicExecUser(String topicExecUser) {
        this.topicExecUser = topicExecUser;
    }
    /**
     * 优化方案简要内容
     */
    public String getBriefScheme() {
        return briefScheme;
    }

    /**
     * 优化方案简要内容
     */
    public void setBriefScheme(String briefScheme) {
        this.briefScheme = briefScheme;
    }
    /**
     * 预计收益及测算依据
     */
    public String getIncomeBasis() {
        return incomeBasis;
    }

    /**
     * 预计收益及测算依据
     */
    public void setIncomeBasis(String incomeBasis) {
        this.incomeBasis = incomeBasis;
    }
    /**
     * 项目经理意见
     */
    public String getManagerOpinion() {
        return managerOpinion;
    }

    /**
     * 项目经理意见
     */
    public void setManagerOpinion(String managerOpinion) {
        this.managerOpinion = managerOpinion;
    }
    /**
     * 所属单位归口管理部门是否同意立项(0:同意，1:不同意)
     */
    public Integer getDepartmentConsentFlag() {
        return departmentConsentFlag;
    }

    /**
     * 所属单位归口管理部门是否同意立项(0:同意，1:不同意)
     */
    public void setDepartmentConsentFlag(Integer departmentConsentFlag) {
        this.departmentConsentFlag = departmentConsentFlag;
    }
    /**
     * 所属单位归口管理部门指导意见
     */
    public String getDepartmentOpinion() {
        return departmentOpinion;
    }

    /**
     * 所属单位归口管理部门指导意见
     */
    public void setDepartmentOpinion(String departmentOpinion) {
        this.departmentOpinion = departmentOpinion;
    }
    /**
     * 所属单位归口管理部门分管领导是否同意立项(0:同意，1:不同意)
     */
    public Integer getLeaderConsentFlag() {
        return leaderConsentFlag;
    }

    /**
     * 所属单位归口管理部门分管领导是否同意立项(0:同意，1:不同意)
     */
    public void setLeaderConsentFlag(Integer leaderConsentFlag) {
        this.leaderConsentFlag = leaderConsentFlag;
    }
    /**
     * 所属单位归口管理部门分管领导指导意见
     */
    public String getLeaderOpinion() {
        return leaderOpinion;
    }

    /**
     * 所属单位归口管理部门分管领导指导意见
     */
    public void setLeaderOpinion(String leaderOpinion) {
        this.leaderOpinion = leaderOpinion;
    }
    /**
     * 项目优化效益计算占用标志(0:未占用，1:已占用)
     */
    public Integer getCalculationOccupyFlag() {
        return calculationOccupyFlag;
    }

    /**
     * 项目优化效益计算占用标志(0:未占用，1:已占用)
     */
    public void setCalculationOccupyFlag(Integer calculationOccupyFlag) {
        this.calculationOccupyFlag = calculationOccupyFlag;
    }
    /**
     * 项目优化奖励申请占用标志(0:未占用，1:已占用)
     */
    public Integer getRewardOccupyFlag() {
        return rewardOccupyFlag;
    }

    /**
     * 项目优化奖励申请占用标志(0:未占用，1:已占用)
     */
    public void setRewardOccupyFlag(Integer rewardOccupyFlag) {
        this.rewardOccupyFlag = rewardOccupyFlag;
    }
    
}
