package com.ejianc.business.zjkjcost.finish.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.zjkjcost.finish.vo.ApplyDetailVO;

/**
 * 竣工考核-目标责任书竣工考核兑现申报-主表
 * 
 * @author generator
 * 
 */
@ApiModel("竣工考核-目标责任书竣工考核兑现申报-主表")
public class ApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同价款")
    private BigDecimal contractMny;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("组织code")
    private String orgCode;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("父级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("单据状态（审批必须字段）")
    private String billStateName;
    private String memo; // 备注
    @ApiModelProperty("竣工考核-目标责任书竣工考核兑现申报-子表")
    private List<ApplyDetailVO> applyDetailList = new ArrayList<>();

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同价款
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同价款
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 申请日期
     */
    public Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织code
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织code
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     /**
      * 竣工考核-目标责任书竣工考核兑现申报-子表
      */
      public List<ApplyDetailVO> getApplyDetailList() {
         return applyDetailList;
      }
     /**
      * 竣工考核-目标责任书竣工考核兑现申报-子表
      */
     public void setApplyDetailList(List<ApplyDetailVO> applyDetailList) {
         this.applyDetailList = applyDetailList;
     }
}
