package com.ejianc.business.zjkjcost.reserve.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.zjkjcost.reserve.vo.AllocateDetailVO;

/**
 * 风险预留金-项目部人员风险金预留分配表
 * 
 * @author generator
 * 
 */
@ApiModel("风险预留金-项目部人员风险金预留分配表")
public class AllocateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("项目部")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("组织")
    private Long parentOrgId;
    @ApiModelProperty("组织名称")
    private String parentOrgName;
    @ApiModelProperty("组织组织编码")
    private String parentOrgCode;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办时间")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date employeeTime;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("初始应预留风险金额")
    private BigDecimal baseShouldReserveMny;
    @ApiModelProperty("初始实际预留风险金额")
    private BigDecimal baseActualReserveMny;
    @ApiModelProperty("初始预留风险比例")
    private BigDecimal baseReserveRatio;
    @ApiModelProperty("应预留风险金额")
    private BigDecimal shouldReserveMny;
    @ApiModelProperty("实际预留风险金额")
    private BigDecimal actualReserveMny;
    @ApiModelProperty("预留风险比例")
    private BigDecimal reserveRatio;
    @ApiModelProperty("变更前应预留风险金额")
    private BigDecimal beforeShouldReserveMny;
    @ApiModelProperty("变更前实际预留风险金额")
    private BigDecimal beforeActualReserveMny;
    @ApiModelProperty("变更前预留风险比例")
    private BigDecimal beforeReserveRatio;
    @ApiModelProperty("变更状态(1-未变更 2-变更中 3-已变更)")
    private Integer changeState;
    @ApiModelProperty("最新变更单id")
    private Long changeId;
    @ApiModelProperty("原单据主键")
    private Long targetId;
    @ApiModelProperty("变更原因")
    private String changeReason;
    @ApiModelProperty("变更时间")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date changeTime;
    @ApiModelProperty("变更编号")
    private String changeCode;
    @ApiModelProperty("变更版本")
    private Integer changeVersion;
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("生效时间")
    private Date effectiveTime;
    
    @ApiModelProperty("风险预留金-项目部人员风险金预留分配表子表")
    private List<AllocateDetailVO> detailList = new ArrayList<>();
    @ApiModelProperty("风险预留金-项目部人员风险金预留分配历史版本表")
    private List<AllocateChangeVO> changeList = new ArrayList<>();
    private List<AllocateApproveVO> approveList = new ArrayList<>(); // 风险预留金-项目部人员风险金预留分配表孙子表

    public List<AllocateApproveVO> getApproveList() {
        return approveList;
    }

    public void setApproveList(List<AllocateApproveVO> approveList) {
        this.approveList = approveList;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目部
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 组织组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 组织组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办时间
     */
    public Date getEmployeeTime() {
        return employeeTime;
    }

    /**
     * 经办时间
     */
    public void setEmployeeTime(Date employeeTime) {
        this.employeeTime = employeeTime;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 初始应预留风险金额
     */
    public BigDecimal getBaseShouldReserveMny() {
        return baseShouldReserveMny;
    }

    /**
     * 初始应预留风险金额
     */
    public void setBaseShouldReserveMny(BigDecimal baseShouldReserveMny) {
        this.baseShouldReserveMny = baseShouldReserveMny;
    }
    /**
     * 初始实际预留风险金额
     */
    public BigDecimal getBaseActualReserveMny() {
        return baseActualReserveMny;
    }

    /**
     * 初始实际预留风险金额
     */
    public void setBaseActualReserveMny(BigDecimal baseActualReserveMny) {
        this.baseActualReserveMny = baseActualReserveMny;
    }
    /**
     * 初始预留风险比例
     */
    public BigDecimal getBaseReserveRatio() {
        return baseReserveRatio;
    }

    /**
     * 初始预留风险比例
     */
    public void setBaseReserveRatio(BigDecimal baseReserveRatio) {
        this.baseReserveRatio = baseReserveRatio;
    }
    /**
     * 应预留风险金额
     */
    public BigDecimal getShouldReserveMny() {
        return shouldReserveMny;
    }

    /**
     * 应预留风险金额
     */
    public void setShouldReserveMny(BigDecimal shouldReserveMny) {
        this.shouldReserveMny = shouldReserveMny;
    }
    /**
     * 实际预留风险金额
     */
    public BigDecimal getActualReserveMny() {
        return actualReserveMny;
    }

    /**
     * 实际预留风险金额
     */
    public void setActualReserveMny(BigDecimal actualReserveMny) {
        this.actualReserveMny = actualReserveMny;
    }
    /**
     * 预留风险比例
     */
    public BigDecimal getReserveRatio() {
        return reserveRatio;
    }

    /**
     * 预留风险比例
     */
    public void setReserveRatio(BigDecimal reserveRatio) {
        this.reserveRatio = reserveRatio;
    }
    /**
     * 变更前应预留风险金额
     */
    public BigDecimal getBeforeShouldReserveMny() {
        return beforeShouldReserveMny;
    }

    /**
     * 变更前应预留风险金额
     */
    public void setBeforeShouldReserveMny(BigDecimal beforeShouldReserveMny) {
        this.beforeShouldReserveMny = beforeShouldReserveMny;
    }
    /**
     * 变更前实际预留风险金额
     */
    public BigDecimal getBeforeActualReserveMny() {
        return beforeActualReserveMny;
    }

    /**
     * 变更前实际预留风险金额
     */
    public void setBeforeActualReserveMny(BigDecimal beforeActualReserveMny) {
        this.beforeActualReserveMny = beforeActualReserveMny;
    }
    /**
     * 变更前预留风险比例
     */
    public BigDecimal getBeforeReserveRatio() {
        return beforeReserveRatio;
    }

    /**
     * 变更前预留风险比例
     */
    public void setBeforeReserveRatio(BigDecimal beforeReserveRatio) {
        this.beforeReserveRatio = beforeReserveRatio;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeState() {
        return changeState;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    /**
     * 最新变更单id
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 最新变更单id
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 原单据主键
     */
    public Long getTargetId() {
        return targetId;
    }

    /**
     * 原单据主键
     */
    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 变更时间
     */
    public Date getChangeTime() {
        return changeTime;
    }

    /**
     * 变更时间
     */
    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }
    /**
     * 变更编号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更编号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    
     /**
      * 风险预留金-项目部人员风险金预留分配表子表
      */
    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public List<AllocateDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AllocateDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<AllocateChangeVO> getChangeList() {
        return changeList;
    }

    public void setChangeList(List<AllocateChangeVO> changeList) {
        this.changeList = changeList;
    }
}
