package com.ejianc.business.zjkjcost.node.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 节点考核-工程项目节点目标奖金审批
 *
 * @author generator
 *
 */
@ApiModel("节点考核-工程项目节点目标奖金审批")
public class NodeApprovalVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("根据目标责任书约定执行")
    private Long assessId;
    @ApiModelProperty("考核单据编号")
    private String assessCode;
    @ApiModelProperty("考核单据名称")
    private String assessName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("申请日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate;
    @ApiModelProperty("申报金额")
    private BigDecimal applyMny;
    @ApiModelProperty("项目目标管理责任书id")
    private Long bookId;
    @ApiModelProperty("项目目标管理责任书名称")
    private String bookName;
    @ApiModelProperty("项目目标管理责任书单据编号")
    private String bookCode;
    @ApiModelProperty("工程项目节点")
    private String projectNode;
    @ApiModelProperty("依据")
    private String basisContent;
    @ApiModelProperty("该项目的节点目标奖金计算如下")
    private String bonusCalculation;
    @ApiModelProperty("节点目标奖金")
    private BigDecimal bonusMny;
    @ApiModelProperty("所属单位财务资金部门扣款金额")
    private BigDecimal financeDeductionMny;
    @ApiModelProperty("所属单位安全生产监督管理部扣款金额")
    private BigDecimal securityDeductionMny;
    @ApiModelProperty("所属单位工程技术研究中心扣款金额")
    private BigDecimal technologyDeductionMny;
    @ApiModelProperty("所属单位建造管理部意见兑现金额")
    private BigDecimal departmentCashMny;
    @ApiModelProperty("所属单位分管领导兑现金额")
    private BigDecimal leaderCashMny;
    @ApiModelProperty("所属单位总经理兑现金额")
    private BigDecimal managerCashMny;
    @ApiModelProperty("所属单位董事长兑现金额")
    private BigDecimal chairmanCashMny;
    @ApiModelProperty("计算依据")
    private String calculationBasisContent;
    @ApiModelProperty("计算过程")
    private String calculationProcess; // 计算过程

    @ApiModelProperty("审批意见——所属单位财务资金部门")
    private String financeDeductionOpinion;
    @ApiModelProperty("审批意见——所属单位安全生产监督管理部")
    private String securityDeductionOpinion;
    @ApiModelProperty("审批意见——所属单位工程技术研究中心")
    private String technologyDeductionOpinion;
    @ApiModelProperty("审批意见——所属单位建造管理部意见")
    private String departmentCashOpinion;
    @ApiModelProperty("审批意见——所属单位分管领导")
    private String leaderCashOpinion;
    @ApiModelProperty("审批意见——所属单位总经理")
    private String managerCashOpinion;
    @ApiModelProperty("审批意见——所属单位董事长")
    private String chairmanCashOpinion;

    private String billStateName;

    public String getFinanceDeductionOpinion() {
        return financeDeductionOpinion;
    }

    public void setFinanceDeductionOpinion(String financeDeductionOpinion) {
        this.financeDeductionOpinion = financeDeductionOpinion;
    }

    public String getSecurityDeductionOpinion() {
        return securityDeductionOpinion;
    }

    public void setSecurityDeductionOpinion(String securityDeductionOpinion) {
        this.securityDeductionOpinion = securityDeductionOpinion;
    }

    public String getTechnologyDeductionOpinion() {
        return technologyDeductionOpinion;
    }

    public void setTechnologyDeductionOpinion(String technologyDeductionOpinion) {
        this.technologyDeductionOpinion = technologyDeductionOpinion;
    }

    public String getDepartmentCashOpinion() {
        return departmentCashOpinion;
    }

    public void setDepartmentCashOpinion(String departmentCashOpinion) {
        this.departmentCashOpinion = departmentCashOpinion;
    }

    public String getLeaderCashOpinion() {
        return leaderCashOpinion;
    }

    public void setLeaderCashOpinion(String leaderCashOpinion) {
        this.leaderCashOpinion = leaderCashOpinion;
    }

    public String getManagerCashOpinion() {
        return managerCashOpinion;
    }

    public void setManagerCashOpinion(String managerCashOpinion) {
        this.managerCashOpinion = managerCashOpinion;
    }

    public String getChairmanCashOpinion() {
        return chairmanCashOpinion;
    }

    public void setChairmanCashOpinion(String chairmanCashOpinion) {
        this.chairmanCashOpinion = chairmanCashOpinion;
    }

    public String getCalculationBasisContent() {
        return calculationBasisContent;
    }

    public void setCalculationBasisContent(String calculationBasisContent) {
        this.calculationBasisContent = calculationBasisContent;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 根据目标责任书约定执行
     */
    @ReferSerialTransfer(referCode="refNodeAssess")
    public Long getAssessId() {
        return assessId;
    }

    /**
     * 根据目标责任书约定执行
     */
    @ReferDeserialTransfer
    public void setAssessId(Long assessId) {
        this.assessId = assessId;
    }
    /**
     * 考核单据编号
     */
    public String getAssessCode() {
        return assessCode;
    }

    /**
     * 考核单据编号
     */
    public void setAssessCode(String assessCode) {
        this.assessCode = assessCode;
    }
    /**
     * 考核单据名称
     */
    public String getAssessName() {
        return assessName;
    }

    /**
     * 考核单据名称
     */
    public void setAssessName(String assessName) {
        this.assessName = assessName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 申请日期
     */
    public Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 申报金额
     */
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申报金额
     */
    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 项目目标管理责任书id
     */
    @ReferSerialTransfer(referCode="refBook")
    public Long getBookId() {
        return bookId;
    }

    /**
     * 项目目标管理责任书id
     */
    @ReferDeserialTransfer
    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }
    /**
     * 项目目标管理责任书名称
     */
    public String getBookName() {
        return bookName;
    }

    /**
     * 项目目标管理责任书名称
     */
    public void setBookName(String bookName) {
        this.bookName = bookName;
    }
    /**
     * 项目目标管理责任书单据编号
     */
    public String getBookCode() {
        return bookCode;
    }

    /**
     * 项目目标管理责任书单据编号
     */
    public void setBookCode(String bookCode) {
        this.bookCode = bookCode;
    }
    /**
     * 工程项目节点
     */
    public String getProjectNode() {
        return projectNode;
    }

    /**
     * 工程项目节点
     */
    public void setProjectNode(String projectNode) {
        this.projectNode = projectNode;
    }
    /**
     * 依据
     */
    public String getBasisContent() {
        return basisContent;
    }

    /**
     * 依据
     */
    public void setBasisContent(String basisContent) {
        this.basisContent = basisContent;
    }
    /**
     * 该项目的节点目标奖金计算如下
     */
    public String getBonusCalculation() {
        return bonusCalculation;
    }

    /**
     * 该项目的节点目标奖金计算如下
     */
    public void setBonusCalculation(String bonusCalculation) {
        this.bonusCalculation = bonusCalculation;
    }
    /**
     * 节点目标奖金
     */
    public BigDecimal getBonusMny() {
        return bonusMny;
    }

    /**
     * 节点目标奖金
     */
    public void setBonusMny(BigDecimal bonusMny) {
        this.bonusMny = bonusMny;
    }
    /**
     * 所属单位财务资金部门扣款金额
     */
    public BigDecimal getFinanceDeductionMny() {
        return financeDeductionMny;
    }

    /**
     * 所属单位财务资金部门扣款金额
     */
    public void setFinanceDeductionMny(BigDecimal financeDeductionMny) {
        this.financeDeductionMny = financeDeductionMny;
    }
    /**
     * 所属单位安全生产监督管理部扣款金额
     */
    public BigDecimal getSecurityDeductionMny() {
        return securityDeductionMny;
    }

    /**
     * 所属单位安全生产监督管理部扣款金额
     */
    public void setSecurityDeductionMny(BigDecimal securityDeductionMny) {
        this.securityDeductionMny = securityDeductionMny;
    }
    /**
     * 所属单位工程技术研究中心扣款金额
     */
    public BigDecimal getTechnologyDeductionMny() {
        return technologyDeductionMny;
    }

    /**
     * 所属单位工程技术研究中心扣款金额
     */
    public void setTechnologyDeductionMny(BigDecimal technologyDeductionMny) {
        this.technologyDeductionMny = technologyDeductionMny;
    }
    /**
     * 所属单位建造管理部意见兑现金额
     */
    public BigDecimal getDepartmentCashMny() {
        return departmentCashMny;
    }

    /**
     * 所属单位建造管理部意见兑现金额
     */
    public void setDepartmentCashMny(BigDecimal departmentCashMny) {
        this.departmentCashMny = departmentCashMny;
    }
    /**
     * 所属单位分管领导兑现金额
     */
    public BigDecimal getLeaderCashMny() {
        return leaderCashMny;
    }

    /**
     * 所属单位分管领导兑现金额
     */
    public void setLeaderCashMny(BigDecimal leaderCashMny) {
        this.leaderCashMny = leaderCashMny;
    }
    /**
     * 所属单位总经理兑现金额
     */
    public BigDecimal getManagerCashMny() {
        return managerCashMny;
    }

    /**
     * 所属单位总经理兑现金额
     */
    public void setManagerCashMny(BigDecimal managerCashMny) {
        this.managerCashMny = managerCashMny;
    }
    /**
     * 所属单位董事长兑现金额
     */
    public BigDecimal getChairmanCashMny() {
        return chairmanCashMny;
    }

    /**
     * 所属单位董事长兑现金额
     */
    public void setChairmanCashMny(BigDecimal chairmanCashMny) {
        this.chairmanCashMny = chairmanCashMny;
    }

    public String getCalculationProcess() {
        return calculationProcess;
    }

    public void setCalculationProcess(String calculationProcess) {
        this.calculationProcess = calculationProcess;
    }
}
