package com.ejianc.business.zjkjcost.subApproval.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 分包结算考核奖审批
 * 
 * @author generator
 * 
 */
@ApiModel("分包结算考核奖审批")
public class SubApprovalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("组织code")
    private String orgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("父级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("文件规定")
    private String documentation;
    @ApiModelProperty("商务管理部审批金额")
    private BigDecimal businessManageMny;
    @ApiModelProperty("总经济师审批金额")
    private BigDecimal economistMny;
    @ApiModelProperty("总经理审批金额")
    private BigDecimal generalManagerMny;
    @ApiModelProperty("董事长审批金额")
    private BigDecimal chairmanMny;
    private BigDecimal applyMny; // 审批金额
    @ApiModelProperty("计算过程")
    private String calculationProcess;
    @ApiModelProperty("提示")
    private String prompt;

    @ApiModelProperty("商务管理部审批意见")
    private String businessManageOpinion;
    @ApiModelProperty("总经济师审批意见")
    private String economistOpinion;
    @ApiModelProperty("总经理审批意见")
    private String generalManagerOpinion;
    @ApiModelProperty("董事长审批意见")
    private String chairmanOpinion;

    private String billStateName;

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getCalculationProcess() {
        return calculationProcess;
    }

    public void setCalculationProcess(String calculationProcess) {
        this.calculationProcess = calculationProcess;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }


    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }


    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织code
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织code
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 文件规定
     */
    public String getDocumentation() {
        return documentation;
    }

    /**
     * 文件规定
     */
    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
    /**
     * 商务管理部审批金额
     */
    public BigDecimal getBusinessManageMny() {
        return businessManageMny;
    }

    /**
     * 商务管理部审批金额
     */
    public void setBusinessManageMny(BigDecimal businessManageMny) {
        this.businessManageMny = businessManageMny;
    }
    /**
     * 总经济师审批金额
     */
    public BigDecimal getEconomistMny() {
        return economistMny;
    }

    /**
     * 总经济师审批金额
     */
    public void setEconomistMny(BigDecimal economistMny) {
        this.economistMny = economistMny;
    }
    /**
     * 总经理审批金额
     */
    public BigDecimal getGeneralManagerMny() {
        return generalManagerMny;
    }

    /**
     * 总经理审批金额
     */
    public void setGeneralManagerMny(BigDecimal generalManagerMny) {
        this.generalManagerMny = generalManagerMny;
    }
    /**
     * 董事长审批金额
     */
    public BigDecimal getChairmanMny() {
        return chairmanMny;
    }

    /**
     * 董事长审批金额
     */
    public void setChairmanMny(BigDecimal chairmanMny) {
        this.chairmanMny = chairmanMny;
    }
    
}
