package com.ejianc.business.zjkjcost.generalApproval.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 总包结算考核奖审批
 *
 * @author generator
 *
 */
@ApiModel("总包结算考核奖审批 ")
public class GeneralApprovalVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("依据")
    private String basisContent;
    @ApiModelProperty("总包结算兑现金额")
    private BigDecimal settleCashMny;
    @ApiModelProperty("项目经理兑现金额")
    private BigDecimal projectManagerCashMny;
    @ApiModelProperty("所属单位商务经理扣款金额")
    private BigDecimal businessManagerDeductionMny;
    @ApiModelProperty("所属单位财务资金部门扣款金额")
    private BigDecimal financeDeductionMny;
    @ApiModelProperty("所属单位建造管理部意见扣款金额")
    private BigDecimal departmentDeductionMny;
    @ApiModelProperty("所属单位工程技术中心扣款金额")
    private BigDecimal technologyDeductionMny;
    @ApiModelProperty("所属单位设计中心扣款金额")
    private BigDecimal designDeductionMny;
    @ApiModelProperty("所属单位分管领导兑现金额")
    private BigDecimal leaderCashMny;
    @ApiModelProperty("所属单位总经理兑现金额")
    private BigDecimal managerCashMny;
    @ApiModelProperty("所属单位董事长兑现金额")
    private BigDecimal chairmanCashMny;
    @ApiModelProperty("计算过程")
    private String countProcess;

    @ApiModelProperty("总包结算兑现金额")
    private String settleCashOpinion;
    @ApiModelProperty("项目经理兑现审批意见")
    private String projectManagerCashOpinion;
    @ApiModelProperty("所属单位商务经理审批意见")
    private String businessManagerDeductionOpinion;
    @ApiModelProperty("所属单位财务资金部门审批意见")
    private String financeDeductionOpinion;
    @ApiModelProperty("所属单位建造管理部意见审批意见")
    private String departmentDeductionOpinion;
    @ApiModelProperty("所属单位工程技术中心审批意见")
    private String technologyDeductionOpinion;
    @ApiModelProperty("所属单位设计中心审批意见")
    private String designDeductionOpinion;
    @ApiModelProperty("所属单位分管领导审批意见")
    private String leaderCashOpinion;
    @ApiModelProperty("所属单位总经理审批意见")
    private String managerCashOpinion;
    @ApiModelProperty("所属单位董事长审批意见")
    private String chairmanCashOpinion;

    public String getSettleCashOpinion() {
        return settleCashOpinion;
    }

    public void setSettleCashOpinion(String settleCashOpinion) {
        this.settleCashOpinion = settleCashOpinion;
    }

    public String getProjectManagerCashOpinion() {
        return projectManagerCashOpinion;
    }

    public void setProjectManagerCashOpinion(String projectManagerCashOpinion) {
        this.projectManagerCashOpinion = projectManagerCashOpinion;
    }

    public String getBusinessManagerDeductionOpinion() {
        return businessManagerDeductionOpinion;
    }

    public void setBusinessManagerDeductionOpinion(String businessManagerDeductionOpinion) {
        this.businessManagerDeductionOpinion = businessManagerDeductionOpinion;
    }

    public String getFinanceDeductionOpinion() {
        return financeDeductionOpinion;
    }

    public void setFinanceDeductionOpinion(String financeDeductionOpinion) {
        this.financeDeductionOpinion = financeDeductionOpinion;
    }

    public String getDepartmentDeductionOpinion() {
        return departmentDeductionOpinion;
    }

    public void setDepartmentDeductionOpinion(String departmentDeductionOpinion) {
        this.departmentDeductionOpinion = departmentDeductionOpinion;
    }

    public String getTechnologyDeductionOpinion() {
        return technologyDeductionOpinion;
    }

    public void setTechnologyDeductionOpinion(String technologyDeductionOpinion) {
        this.technologyDeductionOpinion = technologyDeductionOpinion;
    }

    public String getDesignDeductionOpinion() {
        return designDeductionOpinion;
    }

    public void setDesignDeductionOpinion(String designDeductionOpinion) {
        this.designDeductionOpinion = designDeductionOpinion;
    }

    public String getLeaderCashOpinion() {
        return leaderCashOpinion;
    }

    public void setLeaderCashOpinion(String leaderCashOpinion) {
        this.leaderCashOpinion = leaderCashOpinion;
    }

    public String getManagerCashOpinion() {
        return managerCashOpinion;
    }

    public void setManagerCashOpinion(String managerCashOpinion) {
        this.managerCashOpinion = managerCashOpinion;
    }

    public String getChairmanCashOpinion() {
        return chairmanCashOpinion;
    }

    public void setChairmanCashOpinion(String chairmanCashOpinion) {
        this.chairmanCashOpinion = chairmanCashOpinion;
    }

    public String getCountProcess() {
        return countProcess;
    }

    public void setCountProcess(String countProcess) {
        this.countProcess = countProcess;
    }

    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 依据
     */
    public String getBasisContent() {
        return basisContent;
    }

    /**
     * 依据
     */
    public void setBasisContent(String basisContent) {
        this.basisContent = basisContent;
    }
    /**
     * 总包结算兑现金额
     */
    public BigDecimal getSettleCashMny() {
        return settleCashMny;
    }

    /**
     * 总包结算兑现金额
     */
    public void setSettleCashMny(BigDecimal settleCashMny) {
        this.settleCashMny = settleCashMny;
    }
    /**
     * 项目经理兑现金额
     */
    public BigDecimal getProjectManagerCashMny() {
        return projectManagerCashMny;
    }

    /**
     * 项目经理兑现金额
     */
    public void setProjectManagerCashMny(BigDecimal projectManagerCashMny) {
        this.projectManagerCashMny = projectManagerCashMny;
    }
    /**
     * 所属单位商务经理扣款金额
     */
    public BigDecimal getBusinessManagerDeductionMny() {
        return businessManagerDeductionMny;
    }

    /**
     * 所属单位商务经理扣款金额
     */
    public void setBusinessManagerDeductionMny(BigDecimal businessManagerDeductionMny) {
        this.businessManagerDeductionMny = businessManagerDeductionMny;
    }
    /**
     * 所属单位财务资金部门扣款金额
     */
    public BigDecimal getFinanceDeductionMny() {
        return financeDeductionMny;
    }

    /**
     * 所属单位财务资金部门扣款金额
     */
    public void setFinanceDeductionMny(BigDecimal financeDeductionMny) {
        this.financeDeductionMny = financeDeductionMny;
    }
    /**
     * 所属单位建造管理部意见扣款金额
     */
    public BigDecimal getDepartmentDeductionMny() {
        return departmentDeductionMny;
    }

    /**
     * 所属单位建造管理部意见扣款金额
     */
    public void setDepartmentDeductionMny(BigDecimal departmentDeductionMny) {
        this.departmentDeductionMny = departmentDeductionMny;
    }
    /**
     * 所属单位工程技术中心扣款金额
     */
    public BigDecimal getTechnologyDeductionMny() {
        return technologyDeductionMny;
    }

    /**
     * 所属单位工程技术中心扣款金额
     */
    public void setTechnologyDeductionMny(BigDecimal technologyDeductionMny) {
        this.technologyDeductionMny = technologyDeductionMny;
    }
    /**
     * 所属单位设计中心扣款金额
     */
    public BigDecimal getDesignDeductionMny() {
        return designDeductionMny;
    }

    /**
     * 所属单位设计中心扣款金额
     */
    public void setDesignDeductionMny(BigDecimal designDeductionMny) {
        this.designDeductionMny = designDeductionMny;
    }
    /**
     * 所属单位分管领导兑现金额
     */
    public BigDecimal getLeaderCashMny() {
        return leaderCashMny;
    }

    /**
     * 所属单位分管领导兑现金额
     */
    public void setLeaderCashMny(BigDecimal leaderCashMny) {
        this.leaderCashMny = leaderCashMny;
    }
    /**
     * 所属单位总经理兑现金额
     */
    public BigDecimal getManagerCashMny() {
        return managerCashMny;
    }

    /**
     * 所属单位总经理兑现金额
     */
    public void setManagerCashMny(BigDecimal managerCashMny) {
        this.managerCashMny = managerCashMny;
    }
    /**
     * 所属单位董事长兑现金额
     */
    public BigDecimal getChairmanCashMny() {
        return chairmanCashMny;
    }

    /**
     * 所属单位董事长兑现金额
     */
    public void setChairmanCashMny(BigDecimal chairmanCashMny) {
        this.chairmanCashMny = chairmanCashMny;
    }

}
