package com.ejianc.business.zjkjcost.node.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 节点考核-项目节点奖分析考核
 *
 * @author generator
 *
 */
@ApiModel("节点考核-项目节点奖分析考核")
public class NodeAssessVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("申请日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("根据目标责任书约定执行")
    private String execBook;
    @ApiModelProperty("合同款价")
    private BigDecimal contractMny;
    @ApiModelProperty("考核依据对象")
    private String assessBasisContent;

    private String billStateName;

    @ApiModelProperty("产值与成本情况")
    private String outputCost;  //产值与成本情况
    @ApiModelProperty("财务资金管理情况")
    private String financialFundManagement; //财务资金管理情况
    @ApiModelProperty("项目经理签字(审批)")
    private String pmanagerSignature;   //项目经理签字(审批)
    @ApiModelProperty("所属单位商务部经理签字(审批)")
    private String cmanagerSignature;   //所属单位商务部经理签字(审批)
    @ApiModelProperty("所属单位财务资金部、总会计师签字(审批)")
    private String caiwukuaijiSign; //所属单位财务资金部、总会计师签字(审批)
    @ApiModelProperty("所属单位分管领导(审批)")
    private String lingdaoQinazi;   //所属单位分管领导(审批)
    @ApiModelProperty("所属单位总经理(审批)")
    private String tmanagerSignature;   //所属单位总经理(审批)
    @ApiModelProperty("所属单位物资设备管理职能部门经理签字")
    private String materialManage;   //所属单位物资设备管理职能部门经理签字

    public String getMaterialManage() {
        return materialManage;
    }

    public void setMaterialManage(String materialManage) {
        this.materialManage = materialManage;
    }


    public String getAssessBasisContent() {
        return assessBasisContent;
    }

    public void setAssessBasisContent(String assessBasisContent) {
        this.assessBasisContent = assessBasisContent;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 申请日期
     */
    public Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 根据目标责任书约定执行
     */
    public String getExecBook() {
        return execBook;
    }

    /**
     * 根据目标责任书约定执行
     */
    public void setExecBook(String execBook) {
        this.execBook = execBook;
    }
    /**
     * 合同款价
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同款价
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public String getOutputCost() {
        return outputCost;
    }

    public void setOutputCost(String outputCost) {
        this.outputCost = outputCost;
    }

    public String getFinancialFundManagement() {
        return financialFundManagement;
    }

    public void setFinancialFundManagement(String financialFundManagement) {
        this.financialFundManagement = financialFundManagement;
    }

    public String getPmanagerSignature() {
        return pmanagerSignature;
    }

    public void setPmanagerSignature(String pmanagerSignature) {
        this.pmanagerSignature = pmanagerSignature;
    }

    public String getCmanagerSignature() {
        return cmanagerSignature;
    }

    public void setCmanagerSignature(String cmanagerSignature) {
        this.cmanagerSignature = cmanagerSignature;
    }

    public String getCaiwukuaijiSign() {
        return caiwukuaijiSign;
    }

    public void setCaiwukuaijiSign(String caiwukuaijiSign) {
        this.caiwukuaijiSign = caiwukuaijiSign;
    }

    public String getLingdaoQinazi() {
        return lingdaoQinazi;
    }

    public void setLingdaoQinazi(String lingdaoQinazi) {
        this.lingdaoQinazi = lingdaoQinazi;
    }

    public String getTmanagerSignature() {
        return tmanagerSignature;
    }

    public void setTmanagerSignature(String tmanagerSignature) {
        this.tmanagerSignature = tmanagerSignature;
    }
}
