package com.ejianc.business.zjkjcost.reserve.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 风险预留金-个人风险金过程返还、转抵审批表
 *
 * @author generator
 *
 */
@ApiModel("风险预留金-个人风险金过程返还、转抵审批表")
public class PersonalApproveVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目部")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("组织")
    private Long parentOrgId;
    @ApiModelProperty("组织名称")
    private String parentOrgName;
    @ApiModelProperty("组织组织编码")
    private String parentOrgCode;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办时间")
    private Date employeeTime;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("原项目ID")
    private Long projectId;
    @ApiModelProperty("原项目名称")
    private String projectName;
    @ApiModelProperty("原项目编号")
    private String projectCode;
    @ApiModelProperty("拟转入现项目名称")
    private String turnProjectName;
    @ApiModelProperty("申请人")
    private Long applicantId;
    @ApiModelProperty("申请人名称")
    private String applicantName;
    @ApiModelProperty("申请事项")
    private String applyClause;
    @ApiModelProperty("申请事项（1-返还，2-转抵）")
    private Integer applyClauseType;
    @ApiModelProperty("申请人银行账户")
    private String applicantBankAccounts;
    @ApiModelProperty("申请人电话")
    private String applicantPhone;
    @ApiModelProperty("开户银行名称")
    private String openingBank;
    @ApiModelProperty("项目部意见")
    private String projectDeptOpinion;
    @ApiModelProperty("财务部意见")
    private String financeDeptOpinion;
    @ApiModelProperty("核定额（财务部）")
    private BigDecimal verifyMny;
    @ApiModelProperty("实际预留（财务部）")
    private BigDecimal actualReserveMny;
    @ApiModelProperty("已转抵（财务部）")
    private BigDecimal remortgageMny;
    @ApiModelProperty("预留风险余额（财务部）")
    private BigDecimal reserveBalanceMny;
    @ApiModelProperty("商务部意见")
    private String businessDeptOpinion;
    @ApiModelProperty("转抵/转低金额(商务部)")
    private BigDecimal businessRemortgageMny;
    @ApiModelProperty("经济师意见")
    private String economyDeptOpinion;
    @ApiModelProperty("转抵/转低金额(经济师)")
    private BigDecimal economyRemortgageMny;
    @ApiModelProperty("总经理意见")
    private String generalDeptOpinion;
    @ApiModelProperty("转抵/转低金额(总经理)")
    private BigDecimal generalRemortgageMny;
    private BigDecimal applicantRemortgageMny; // 申请返还/转抵金额

    private String billStateName;


    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目部
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 组织组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 组织组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办时间
     */
    public Date getEmployeeTime() {
        return employeeTime;
    }

    /**
     * 经办时间
     */
    public void setEmployeeTime(Date employeeTime) {
        this.employeeTime = employeeTime;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 原项目ID
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 原项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 原项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 原项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 原项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 原项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 拟转入现项目名称
     */
    public String getTurnProjectName() {
        return turnProjectName;
    }

    /**
     * 拟转入现项目名称
     */
    public void setTurnProjectName(String turnProjectName) {
        this.turnProjectName = turnProjectName;
    }
    /**
     * 申请人
     */
    @ReferSerialTransfer(referCode="allocateApplicant")
    public Long getApplicantId() {
        return applicantId;
    }

    /**
     * 申请人
     */
    @ReferDeserialTransfer
    public void setApplicantId(Long applicantId) {
        this.applicantId = applicantId;
    }
    /**
     * 申请人名称
     */
    public String getApplicantName() {
        return applicantName;
    }

    /**
     * 申请人名称
     */
    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }
    /**
     * 申请事项
     */
    public String getApplyClause() {
        return applyClause;
    }

    /**
     * 申请事项
     */
    public void setApplyClause(String applyClause) {
        this.applyClause = applyClause;
    }
    /**
     * 申请事项（1-返还，2-转抵）
     */
    public Integer getApplyClauseType() {
        return applyClauseType;
    }

    /**
     * 申请事项（1-返还，2-转抵）
     */
    public void setApplyClauseType(Integer applyClauseType) {
        this.applyClauseType = applyClauseType;
    }
    /**
     * 申请人银行账户
     */
    public String getApplicantBankAccounts() {
        return applicantBankAccounts;
    }

    /**
     * 申请人银行账户
     */
    public void setApplicantBankAccounts(String applicantBankAccounts) {
        this.applicantBankAccounts = applicantBankAccounts;
    }
    /**
     * 申请人电话
     */
    public String getApplicantPhone() {
        return applicantPhone;
    }

    /**
     * 申请人电话
     */
    public void setApplicantPhone(String applicantPhone) {
        this.applicantPhone = applicantPhone;
    }
    /**
     * 开户银行名称
     */
    public String getOpeningBank() {
        return openingBank;
    }

    /**
     * 开户银行名称
     */
    public void setOpeningBank(String openingBank) {
        this.openingBank = openingBank;
    }
    /**
     * 项目部意见
     */
    public String getProjectDeptOpinion() {
        return projectDeptOpinion;
    }

    /**
     * 项目部意见
     */
    public void setProjectDeptOpinion(String projectDeptOpinion) {
        this.projectDeptOpinion = projectDeptOpinion;
    }
    /**
     * 财务部意见
     */
    public String getFinanceDeptOpinion() {
        return financeDeptOpinion;
    }

    /**
     * 财务部意见
     */
    public void setFinanceDeptOpinion(String financeDeptOpinion) {
        this.financeDeptOpinion = financeDeptOpinion;
    }
    /**
     * 核定额（财务部）
     */
    public BigDecimal getVerifyMny() {
        return verifyMny;
    }

    /**
     * 核定额（财务部）
     */
    public void setVerifyMny(BigDecimal verifyMny) {
        this.verifyMny = verifyMny;
    }
    /**
     * 实际预留（财务部）
     */
    public BigDecimal getActualReserveMny() {
        return actualReserveMny;
    }

    /**
     * 实际预留（财务部）
     */
    public void setActualReserveMny(BigDecimal actualReserveMny) {
        this.actualReserveMny = actualReserveMny;
    }
    /**
     * 已转抵（财务部）
     */
    public BigDecimal getRemortgageMny() {
        return remortgageMny;
    }

    /**
     * 已转抵（财务部）
     */
    public void setRemortgageMny(BigDecimal remortgageMny) {
        this.remortgageMny = remortgageMny;
    }
    /**
     * 预留风险余额（财务部）
     */
    public BigDecimal getReserveBalanceMny() {
        return reserveBalanceMny;
    }

    /**
     * 预留风险余额（财务部）
     */
    public void setReserveBalanceMny(BigDecimal reserveBalanceMny) {
        this.reserveBalanceMny = reserveBalanceMny;
    }
    /**
     * 商务部意见
     */
    public String getBusinessDeptOpinion() {
        return businessDeptOpinion;
    }

    /**
     * 商务部意见
     */
    public void setBusinessDeptOpinion(String businessDeptOpinion) {
        this.businessDeptOpinion = businessDeptOpinion;
    }
    /**
     * 转抵/转低金额(商务部)
     */
    public BigDecimal getBusinessRemortgageMny() {
        return businessRemortgageMny;
    }

    /**
     * 转抵/转低金额(商务部)
     */
    public void setBusinessRemortgageMny(BigDecimal businessRemortgageMny) {
        this.businessRemortgageMny = businessRemortgageMny;
    }
    /**
     * 经济师意见
     */
    public String getEconomyDeptOpinion() {
        return economyDeptOpinion;
    }

    /**
     * 经济师意见
     */
    public void setEconomyDeptOpinion(String economyDeptOpinion) {
        this.economyDeptOpinion = economyDeptOpinion;
    }
    /**
     * 转抵/转低金额(经济师)
     */
    public BigDecimal getEconomyRemortgageMny() {
        return economyRemortgageMny;
    }

    /**
     * 转抵/转低金额(经济师)
     */
    public void setEconomyRemortgageMny(BigDecimal economyRemortgageMny) {
        this.economyRemortgageMny = economyRemortgageMny;
    }
    /**
     * 总经理意见
     */
    public String getGeneralDeptOpinion() {
        return generalDeptOpinion;
    }

    /**
     * 总经理意见
     */
    public void setGeneralDeptOpinion(String generalDeptOpinion) {
        this.generalDeptOpinion = generalDeptOpinion;
    }
    /**
     * 转抵/转低金额(总经理)
     */
    public BigDecimal getGeneralRemortgageMny() {
        return generalRemortgageMny;
    }

    /**
     * 转抵/转低金额(总经理)
     */
    public void setGeneralRemortgageMny(BigDecimal generalRemortgageMny) {
        this.generalRemortgageMny = generalRemortgageMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getApplicantRemortgageMny() {
        return applicantRemortgageMny;
    }

    public void setApplicantRemortgageMny(BigDecimal applicantRemortgageMny) {
        this.applicantRemortgageMny = applicantRemortgageMny;
    }
}
