package com.ejianc.business.zjkjcost.manage.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

/**
 * 收入合同
 * 
 * @author generator
 *
 */
public class IncontractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String fileState; // 归档状态
    private Long userDeptId; // 创建人部门
    private Long reportId; // 报表id
    private Integer billState; // 单据状态
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目id
    private String billCode; // 合同编号
    private String contractName; // 合同名称
    private String type; // 承包类型
    private Long promoter; // 发包人
    private String promoterName; // 发包人名称
    private Long promoterNature; // 发包人性质
    private String promoterNatureName; // 发包人性质名称
    private String promoterSocialCreditCode; // 统一社会信用代码
    private String promoterAdress; // 发包人地址
    private String promoterLegal; // 法人代表
    private String promoterTelephone; // 法人电话
    private Long contractualModel; // 承包模式
    private String contractualModelName; // 承包模式名称
    private String projectScale; // 工程规模
    private String priceMethod; // 计价方式
    private String structureType; // 结构类型
    private BigDecimal contractAmount; // 合同额
    private BigDecimal selfConstructionContractAmount; // 自施合同额
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工日期
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualStartDate; // 实际开工日期(合同冗余字段)
    private Integer duration; // 工期
    private String contractBriefContent; // 合同简要内容
    private BigDecimal projectBidProfitMargin; // 项目投标利润率
    private Long signUnit; // 签约单位
    private String signUnitName; // 签约单位名称
    private Long buildUnit; // 施工单位
    private String buildUnitName; // 实施单位名称
    private Long qualityAgreement; // 质量约定
    private String consortiumWonBid; // 是否联合体中标
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签约日期
    private Long projectCategory; // 项目类别
    private String projectCategoryName; // 项目类别名称
    private String investmentProject; // 融投资带动项目
    private Long signStatus; // 签约状态
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date notificationAwardDate; // 中标通知书日期
    private Long biddingForm; // 招标形式
    private String integratedCode; // 一体化编码
    private String projectLocation; // 工程地点
    private String projectArea; // 工程地点--具体文本信息
    private String durationDescription; // 工期描述
    private String jobContent; // 工作内容
    private BigDecimal quotaPriceDownwardRate; //  定额计价下浮率
    private String waiverPriority; // 是否放弃优先受偿权
    private BigDecimal constructionInstallationFee; //  建安费金额（元）
    private BigDecimal constructionInstallationFeeProportion; //  建安费占比
    private String constructionInstallationFeePriceMethod; // 建安费计价方式
    private BigDecimal internalRate; //  内部收益率
    private String revenueModel; // 收益模式
    private BigDecimal revenueReturnCycle; //  收益回报周期（月）
    private BigDecimal generalConstructionProfit; //  施工总承包利润率
    private BigDecimal totalInvestment; //  总投资额
    private String estateProject; // 是否为地产类项目
    
    private BigDecimal taxRate; // 税率

    private BigDecimal afterChangeAmount; // 变更后金额
    private BigDecimal changeAmount; // 变更金额
    
    private String consortiumName; // 联合体方名称
    private BigDecimal consortiumContractAmount; //  联合体方合同额（元）
    private String consortiumCooperationContent; // 联合体方合作内容
    
    private String advancePaymentExit; // 是否有预付款
    private BigDecimal advancePaymentLimit;//預付款額度
    private BigDecimal advancePaymentProportion; // 预付款比例（%）
    private String advancePaymentDeductionMethod; // 预付款抵扣方式
    private BigDecimal monthlyPaymentProportion; // 月度付款比例（%）

    private BigDecimal nodePaymentProportion; // 节点付款比例（%）
    private String payment;//付款方式
    private String paymentProportion;

    private String nodePaymentDetail; // 节点付款明细
    private BigDecimal completionAcceptancePaymentProportion; // 竣工验收付款比例（%）
    private BigDecimal deliveryPaymentRatio; // 交付付款比例（%）
    private BigDecimal afterSettlementPaymentProportion; // 结算完成付款比例（%）
    private BigDecimal paymentPeriod; // 付款周期（月）
    private Long paymentMethod; // 单一支付方式
    private String descriptionPaymentMethod; // 组合支付方式
    private String otherPaymentCondition; // 其他费用付款条件（如：设计费）

    private String rcjAdjustable; // 是否可调（人材机调差）
    private String rcjMaterialAdjustableRange; // 材料可调差范围（人材机调差）


    private BigDecimal rcjMaterialStartAdjustableProportion; // 材料费起调比例（人材机调差）
    private String rcjMaterialStartAdjustableProportionIf;//材料费是否
    private BigDecimal rcjLabourStartAdjustableProportion; // 人工费起调比例（人材机调差）
    private String otherMeasureAdjustable; // 措施费是否可调（其他调整）
    private String otherNegotiationChangeAdjustable; // 洽商变更是否可调（其他调整）
    private String processMeasurement; // 是否约定过程计量（过程计量）
    private Integer processReportTimeLimit; // 进度上报审核时限(天)（过程计量）
    private Integer processAfterApprovalPaymentTimeLimit; // 审核后付款时限（过程计量）
    private String remark; // 备注
    private String changeState; // 变更状态
    private Long changeId; // 变更单据
    private Long agent; // 经办人
    private String agentName; // 经办人
    private Long agentDeptId; // 经办人部门
    private String agentDeptName; // 经办人部门名称

    private String fundSource; // 课题经费来源
    private Integer performanceStatus; // 履约状态

    private BigDecimal totalSubcontracteQuota; // 甲指分包额度汇总
    
    /**违约信息start**/
    private BigDecimal durationDailyLiquidatedDamagesProportion; // 合同约定工期违约-日违约金比例（%）
    private BigDecimal durationDailyLiquidatedDamagesAmount; // 合同约定工期违约-日违约金金额
    private String durationLiquidatedDamagesUpperLimitExit; // 合同约定工期违约-是否有违约金上限
    private BigDecimal durationLiquidatedDamagesUpperLimit; // 合同约定工期违约-违约金上限
    private BigDecimal qualityLiquidatedDamagesAmount; // 合同约定质量违约-违约金
    private String qualityLiquidatedDamagesUpperLimitExit; // 合同约定质量违约-是否有违约金上限
    private BigDecimal qualityLiquidatedDamagesUpperLimit; // 合同约定质量违约-违约金上限
    /**违约信息start**/

    /**结算与担保start**/
    private String settlementTimeLimitSure; // 结算时限是否明确
    private String financialAudit; // 财政审计/第三方审计
    private Integer settlementTimeLimit; // 结算时限(月)
    private Long paymentGuaranteeForm; // 支付担保-形式
    private BigDecimal paymentGuaranteeAmount; // 支付担保-金额
    private Long advancePaymentGuaranteeForm; // 预付款担保-形式
    private BigDecimal advancePaymentGuaranteeProportion; // 预付款担保-比例
    private Long performanceGuaranteeForm; // 履约担保-形式
    private BigDecimal performanceGuaranteeProportion; // 履约担保-比例
    private Long warrantyDepositForm; // 质保金-形式
    private BigDecimal warrantyDepositProportion; // 质保金-比例
    /**结算与担保start**/
    




    /***********合同评审数据start*************/
    // 原则上不予签订合同的情形
    private String cashPerformanceBond; // 收取现金履约保证金,1:选中，0未选中
    private String periodBreachNoLimit ; // 工期违约罚则无上限,1:选中，0未选中
    private String qualityBreachNoLimit; // 质量违约罚责无上限,1:选中，0未选中
    
    // 重大风险合同标准符合项选择
    private String projectOperationBenefit;// 项目经营效益低于6 %,1:选中，0未选中
    private String proceduresLack;// 建设项目行政审批手续缺失、不齐全；如项目未立项，不动产权证、建设用地规划许可证及建设工程规划许可证不齐全等,1:选中，0未选中
    private String monthlyProgressPayment;// 月进度付款低于70%、节点付款低于70%或节点支付、确权间隔超过3个月的,1:选中，0未选中
    private String acceptancePaymentProportion;// 项目竣工验收支付比例低于85%的,1:选中，0未选中
    private String advanceMoney;// 垫资超过5000万元或超过合同额10%的,1:选中，0未选中
    private String nonCash;// 须一事一议，单独审批）商业承兑汇票、抵押等非现金支付；,1:选中，0未选中
    private String fixedLumpSum;// 固定总价包干及固定单价合同且施工周期在1年及以上的变更签证及主材人工均不调差的,1:选中，0未选中
    private String unconditional;// 无条件禁止承包商停、缓建权利或停缓建情形下索赔权利的；,1:选中，0未选中
    private String nonFinancial;// 非财政/国有资金投资，未约定结算时限、流程或结算时限超过6个月的,1:选中，0未选中
    
    private String contractStandardFinish; // 是否完成重大风险标准选择
    

    /***********合同评审数据end*************/
    
    /**导出处理数据start**/
    private String signDateShow; // 签约日期
    private String createTimeShow; // 创建时间
    private String changeStateName; // 变更状态
    private String billStateName; // 单据状态

    private String signStatusName; // 签约状态
    private String endDateShow; // 竣工日期
    private String startDateShow; // 开工日期
    private String notificationAwardDateShow; // 中标通知书日期
    private String biddingFormName; // 招标形式
    private String qualityAgreementName; // 质量约定
    private String paymentMethodName; // 单一支付方式---导出使用
    private String paymentGuaranteeFormName; // 支付担保-形式
    private String advancePaymentGuaranteeFormName; // 预付款担保-形式
    private String performanceGuaranteeFormName; // 创建时间
    private String warrantyDepositFormName; // 质保金-形式

    private String settlementTimeLimitShow; // 竣工结算审核期限
    
    /**导出处理数据end**/
    private String booktype; // 台账类型

    public String getPayment() {
        return payment;
    }

    public void setPayment(String payment) {
        this.payment = payment;
    }


    public String getPaymentProportion() {
        return paymentProportion;
    }

    public void setPaymentProportion(String paymentProportion) {
        this.paymentProportion = paymentProportion;
    }



    public BigDecimal getAdvancePaymentLimit() {
        return advancePaymentLimit;
    }

    public void setAdvancePaymentLimit(BigDecimal advancePaymentLimit) {
        this.advancePaymentLimit = advancePaymentLimit;
    }


    public String getRcjMaterialStartAdjustableProportionIf() {
        return rcjMaterialStartAdjustableProportionIf;
    }

    public void setRcjMaterialStartAdjustableProportionIf(String rcjMaterialStartAdjustableProportionIf) {
        this.rcjMaterialStartAdjustableProportionIf = rcjMaterialStartAdjustableProportionIf;
    }


    public Integer getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(Integer performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }


    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getPromoter() {
        return promoter;
    }

    @ReferDeserialTransfer
    public void setPromoter(Long promoter) {
        this.promoter = promoter;
    }

    public String getPromoterName() {
        return promoterName;
    }

    public void setPromoterName(String promoterName) {
        this.promoterName = promoterName;
    }

    public Long getPromoterNature() {
        return promoterNature;
    }

    public void setPromoterNature(Long promoterNature) {
        this.promoterNature = promoterNature;
    }

	public String getPromoterNatureName() {
		return promoterNatureName;
	}

	public void setPromoterNatureName(String promoterNatureName) {
		this.promoterNatureName = promoterNatureName;
	}

    public String getPromoterSocialCreditCode() {
        return promoterSocialCreditCode;
    }

    public void setPromoterSocialCreditCode(String promoterSocialCreditCode) {
        this.promoterSocialCreditCode = promoterSocialCreditCode;
    }

    public String getPromoterAdress() {
        return promoterAdress;
    }

    public void setPromoterAdress(String promoterAdress) {
        this.promoterAdress = promoterAdress;
    }

    public String getPromoterLegal() {
        return promoterLegal;
    }

    public void setPromoterLegal(String promoterLegal) {
        this.promoterLegal = promoterLegal;
    }

    public String getPromoterTelephone() {
        return promoterTelephone;
    }

    public void setPromoterTelephone(String promoterTelephone) {
        this.promoterTelephone = promoterTelephone;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }

    public String getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getSelfConstructionContractAmount() {
        return selfConstructionContractAmount;
    }

    public void setSelfConstructionContractAmount(BigDecimal selfConstructionContractAmount) {
        this.selfConstructionContractAmount = selfConstructionContractAmount;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }
    
    public String getContractBriefContent() {
        return contractBriefContent;
    }

    public void setContractBriefContent(String contractBriefContent) {
        this.contractBriefContent = contractBriefContent;
    }

    public BigDecimal getProjectBidProfitMargin() {
        return projectBidProfitMargin;
    }

    public void setProjectBidProfitMargin(BigDecimal projectBidProfitMargin) {
        this.projectBidProfitMargin = projectBidProfitMargin;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getSignUnit() {
        return signUnit;
    }

    @ReferDeserialTransfer
    public void setSignUnit(Long signUnit) {
        this.signUnit = signUnit;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getBuildUnit() {
        return buildUnit;
    }

    @ReferDeserialTransfer
    public void setBuildUnit(Long buildUnit) {
        this.buildUnit = buildUnit;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getQualityAgreement() {
        return qualityAgreement;
    }

    @ReferDeserialTransfer
    public void setQualityAgreement(Long qualityAgreement) {
        this.qualityAgreement = qualityAgreement;
    }

    public String getConsortiumWonBid() {
        return consortiumWonBid;
    }

    public void setConsortiumWonBid(String consortiumWonBid) {
        this.consortiumWonBid = consortiumWonBid;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectCategory() {
        return projectCategory;
    }

    @ReferDeserialTransfer
    public void setProjectCategory(Long projectCategory) {
        this.projectCategory = projectCategory;
    }

	public String getProjectCategoryName() {
		return projectCategoryName;
	}

	public void setProjectCategoryName(String projectCategoryName) {
		this.projectCategoryName = projectCategoryName;
	}

    public String getInvestmentProject() {
        return investmentProject;
    }

    public void setInvestmentProject(String investmentProject) {
        this.investmentProject = investmentProject;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getSignStatus() {
        return signStatus;
    }

    @ReferDeserialTransfer
    public void setSignStatus(Long signStatus) {
        this.signStatus = signStatus;
    }

    public Date getNotificationAwardDate() {
        return notificationAwardDate;
    }

    public void setNotificationAwardDate(Date notificationAwardDate) {
        this.notificationAwardDate = notificationAwardDate;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getBiddingForm() {
        return biddingForm;
    }

    @ReferDeserialTransfer
    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public String getIntegratedCode() {
        return integratedCode;
    }

    public void setIntegratedCode(String integratedCode) {
        this.integratedCode = integratedCode;
    }

    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }

	public String getProjectArea() {
		return projectArea;
	}

	public void setProjectArea(String projectArea) {
		this.projectArea = projectArea;
	}

    public String getDurationDescription() {
        return durationDescription;
    }

    public void setDurationDescription(String durationDescription) {
        this.durationDescription = durationDescription;
    }
    
    public String getJobContent() {
        return jobContent;
    }

    public BigDecimal getQuotaPriceDownwardRate() {
		return quotaPriceDownwardRate;
	}

	public void setQuotaPriceDownwardRate(BigDecimal quotaPriceDownwardRate) {
		this.quotaPriceDownwardRate = quotaPriceDownwardRate;
	}

	public String getConsortiumName() {
		return consortiumName;
	}

	public void setConsortiumName(String consortiumName) {
		this.consortiumName = consortiumName;
	}

	public BigDecimal getConsortiumContractAmount() {
		return consortiumContractAmount;
	}

	public void setConsortiumContractAmount(BigDecimal consortiumContractAmount) {
		this.consortiumContractAmount = consortiumContractAmount;
	}

	public String getConsortiumCooperationContent() {
		return consortiumCooperationContent;
	}

	public void setConsortiumCooperationContent(String consortiumCooperationContent) {
		this.consortiumCooperationContent = consortiumCooperationContent;
	}

	public BigDecimal getAdvancePaymentProportion() {
		return advancePaymentProportion;
	}

	public void setAdvancePaymentProportion(BigDecimal advancePaymentProportion) {
		this.advancePaymentProportion = advancePaymentProportion;
	}

	public String getAdvancePaymentDeductionMethod() {
		return advancePaymentDeductionMethod;
	}

	public void setAdvancePaymentDeductionMethod(String advancePaymentDeductionMethod) {
		this.advancePaymentDeductionMethod = advancePaymentDeductionMethod;
	}

	public BigDecimal getMonthlyPaymentProportion() {
		return monthlyPaymentProportion;
	}

	public void setJobContent(String jobContent) {
		this.jobContent = jobContent;
	}

	public void setMonthlyPaymentProportion(BigDecimal monthlyPaymentProportion) {
        this.monthlyPaymentProportion = monthlyPaymentProportion;
    }

    public BigDecimal getNodePaymentProportion() {
        return nodePaymentProportion;
    }

    public void setNodePaymentProportion(BigDecimal nodePaymentProportion) {
        this.nodePaymentProportion = nodePaymentProportion;
    }

    public String getNodePaymentDetail() {
        return nodePaymentDetail;
    }

    public void setNodePaymentDetail(String nodePaymentDetail) {
        this.nodePaymentDetail = nodePaymentDetail;
    }

    public BigDecimal getCompletionAcceptancePaymentProportion() {
        return completionAcceptancePaymentProportion;
    }

    public void setCompletionAcceptancePaymentProportion(BigDecimal completionAcceptancePaymentProportion) {
        this.completionAcceptancePaymentProportion = completionAcceptancePaymentProportion;
    }

    public BigDecimal getDeliveryPaymentRatio() {
        return deliveryPaymentRatio;
    }

    public void setDeliveryPaymentRatio(BigDecimal deliveryPaymentRatio) {
        this.deliveryPaymentRatio = deliveryPaymentRatio;
    }

    public BigDecimal getAfterSettlementPaymentProportion() {
        return afterSettlementPaymentProportion;
    }

    public void setAfterSettlementPaymentProportion(BigDecimal afterSettlementPaymentProportion) {
        this.afterSettlementPaymentProportion = afterSettlementPaymentProportion;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPaymentMethod() {
        return paymentMethod;
    }

    @ReferDeserialTransfer
    public void setPaymentMethod(Long paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getDescriptionPaymentMethod() {
        return descriptionPaymentMethod;
    }

    public void setDescriptionPaymentMethod(String descriptionPaymentMethod) {
        this.descriptionPaymentMethod = descriptionPaymentMethod;
    }

    public String getRcjAdjustable() {
        return rcjAdjustable;
    }

    public void setRcjAdjustable(String rcjAdjustable) {
        this.rcjAdjustable = rcjAdjustable;
    }

    public String getRcjMaterialAdjustableRange() {
        return rcjMaterialAdjustableRange;
    }

    public void setRcjMaterialAdjustableRange(String rcjMaterialAdjustableRange) {
        this.rcjMaterialAdjustableRange = rcjMaterialAdjustableRange;
    }

    public BigDecimal getRcjMaterialStartAdjustableProportion() {
        return rcjMaterialStartAdjustableProportion;
    }

    public void setRcjMaterialStartAdjustableProportion(BigDecimal rcjMaterialStartAdjustableProportion) {
        this.rcjMaterialStartAdjustableProportion = rcjMaterialStartAdjustableProportion;
    }

    public BigDecimal getRcjLabourStartAdjustableProportion() {
        return rcjLabourStartAdjustableProportion;
    }

    public void setRcjLabourStartAdjustableProportion(BigDecimal rcjLabourStartAdjustableProportion) {
        this.rcjLabourStartAdjustableProportion = rcjLabourStartAdjustableProportion;
    }

    public String getOtherMeasureAdjustable() {
        return otherMeasureAdjustable;
    }

    public void setOtherMeasureAdjustable(String otherMeasureAdjustable) {
        this.otherMeasureAdjustable = otherMeasureAdjustable;
    }

    public String getOtherNegotiationChangeAdjustable() {
        return otherNegotiationChangeAdjustable;
    }

    public void setOtherNegotiationChangeAdjustable(String otherNegotiationChangeAdjustable) {
        this.otherNegotiationChangeAdjustable = otherNegotiationChangeAdjustable;
    }

    public String getProcessMeasurement() {
        return processMeasurement;
    }

    public void setProcessMeasurement(String processMeasurement) {
        this.processMeasurement = processMeasurement;
    }

    public Integer getProcessReportTimeLimit() {
        return processReportTimeLimit;
    }

    public void setProcessReportTimeLimit(Integer processReportTimeLimit) {
        this.processReportTimeLimit = processReportTimeLimit;
    }

    public Integer getProcessAfterApprovalPaymentTimeLimit() {
        return processAfterApprovalPaymentTimeLimit;
    }

    public void setProcessAfterApprovalPaymentTimeLimit(Integer processAfterApprovalPaymentTimeLimit) {
        this.processAfterApprovalPaymentTimeLimit = processAfterApprovalPaymentTimeLimit;
    }

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getChangeState() {
		return changeState;
	}

	public void setChangeState(String changeState) {
		this.changeState = changeState;
	}

	public BigDecimal getDurationDailyLiquidatedDamagesProportion() {
		return durationDailyLiquidatedDamagesProportion;
	}

	public void setDurationDailyLiquidatedDamagesProportion(BigDecimal durationDailyLiquidatedDamagesProportion) {
		this.durationDailyLiquidatedDamagesProportion = durationDailyLiquidatedDamagesProportion;
	}

	public BigDecimal getDurationDailyLiquidatedDamagesAmount() {
		return durationDailyLiquidatedDamagesAmount;
	}

	public void setDurationDailyLiquidatedDamagesAmount(BigDecimal durationDailyLiquidatedDamagesAmount) {
		this.durationDailyLiquidatedDamagesAmount = durationDailyLiquidatedDamagesAmount;
	}

	public BigDecimal getDurationLiquidatedDamagesUpperLimit() {
		return durationLiquidatedDamagesUpperLimit;
	}

	public void setDurationLiquidatedDamagesUpperLimit(BigDecimal durationLiquidatedDamagesUpperLimit) {
		this.durationLiquidatedDamagesUpperLimit = durationLiquidatedDamagesUpperLimit;
	}

	public BigDecimal getQualityLiquidatedDamagesAmount() {
		return qualityLiquidatedDamagesAmount;
	}

	public void setQualityLiquidatedDamagesAmount(BigDecimal qualityLiquidatedDamagesAmount) {
		this.qualityLiquidatedDamagesAmount = qualityLiquidatedDamagesAmount;
	}

	public BigDecimal getQualityLiquidatedDamagesUpperLimit() {
		return qualityLiquidatedDamagesUpperLimit;
	}

	public void setQualityLiquidatedDamagesUpperLimit(BigDecimal qualityLiquidatedDamagesUpperLimit) {
		this.qualityLiquidatedDamagesUpperLimit = qualityLiquidatedDamagesUpperLimit;
	}

	public String getFinancialAudit() {
		return financialAudit;
	}

	public void setFinancialAudit(String financialAudit) {
		this.financialAudit = financialAudit;
	}

	public Integer getSettlementTimeLimit() {
		return settlementTimeLimit;
	}

	public void setSettlementTimeLimit(Integer settlementTimeLimit) {
		this.settlementTimeLimit = settlementTimeLimit;
	}

    @ReferSerialTransfer(referCode="support-defdoc")
	public Long getPaymentGuaranteeForm() {
		return paymentGuaranteeForm;
	}

    @ReferDeserialTransfer
	public void setPaymentGuaranteeForm(Long paymentGuaranteeForm) {
		this.paymentGuaranteeForm = paymentGuaranteeForm;
	}

	public BigDecimal getPaymentGuaranteeAmount() {
		return paymentGuaranteeAmount;
	}

	public void setPaymentGuaranteeAmount(BigDecimal paymentGuaranteeAmount) {
		this.paymentGuaranteeAmount = paymentGuaranteeAmount;
	}

    @ReferSerialTransfer(referCode="support-defdoc")
	public Long getAdvancePaymentGuaranteeForm() {
		return advancePaymentGuaranteeForm;
	}

    @ReferDeserialTransfer
	public void setAdvancePaymentGuaranteeForm(Long advancePaymentGuaranteeForm) {
		this.advancePaymentGuaranteeForm = advancePaymentGuaranteeForm;
	}

	public BigDecimal getAdvancePaymentGuaranteeProportion() {
		return advancePaymentGuaranteeProportion;
	}

	public void setAdvancePaymentGuaranteeProportion(BigDecimal advancePaymentGuaranteeProportion) {
		this.advancePaymentGuaranteeProportion = advancePaymentGuaranteeProportion;
	}

    @ReferSerialTransfer(referCode="support-defdoc")
	public Long getPerformanceGuaranteeForm() {
		return performanceGuaranteeForm;
	}

    @ReferDeserialTransfer
	public void setPerformanceGuaranteeForm(Long performanceGuaranteeForm) {
		this.performanceGuaranteeForm = performanceGuaranteeForm;
	}

	public BigDecimal getPerformanceGuaranteeProportion() {
		return performanceGuaranteeProportion;
	}

	public void setPerformanceGuaranteeProportion(BigDecimal performanceGuaranteeProportion) {
		this.performanceGuaranteeProportion = performanceGuaranteeProportion;
	}

    @ReferSerialTransfer(referCode="support-defdoc")
	public Long getWarrantyDepositForm() {
		return warrantyDepositForm;
	}

    @ReferDeserialTransfer
	public void setWarrantyDepositForm(Long warrantyDepositForm) {
		this.warrantyDepositForm = warrantyDepositForm;
	}

	public BigDecimal getWarrantyDepositProportion() {
		return warrantyDepositProportion;
	}

	public void setWarrantyDepositProportion(BigDecimal warrantyDepositProportion) {
		this.warrantyDepositProportion = warrantyDepositProportion;
	}

	public String getSignUnitName() {
		return signUnitName;
	}

	public void setSignUnitName(String signUnitName) {
		this.signUnitName = signUnitName;
	}

	public String getBuildUnitName() {
		return buildUnitName;
	}

	public void setBuildUnitName(String buildUnitName) {
		this.buildUnitName = buildUnitName;
	}

	public String getStructureType() {
		return structureType;
	}

	public void setStructureType(String structureType) {
		this.structureType = structureType;
	}

	public Long getChangeId() {
		return changeId;
	}

	public void setChangeId(Long changeId) {
		this.changeId = changeId;
	}

    @ReferSerialTransfer(referCode="idm-employee")
	public Long getAgent() {
		return agent;
	}

    @ReferDeserialTransfer
	public void setAgent(Long agent) {
		this.agent = agent;
	}

	public String getSignDateShow() {
		return signDateShow;
	}

	public void setSignDateShow(String signDateShow) {
		this.signDateShow = signDateShow;
	}

	public String getCreateTimeShow() {
		return createTimeShow;
	}

	public void setCreateTimeShow(String createTimeShow) {
		this.createTimeShow = createTimeShow;
	}

	public String getAgentName() {
		return agentName;
	}

	public void setAgentName(String agentName) {
		this.agentName = agentName;
	}

	public String getChangeStateName() {
		return changeStateName;
	}

	public void setChangeStateName(String changeStateName) {
		this.changeStateName = changeStateName;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Date getActualStartDate() {
		return actualStartDate;
	}

	public void setActualStartDate(Date actualStartDate) {
		this.actualStartDate = actualStartDate;
	}

	public BigDecimal getTotalSubcontracteQuota() {
		return totalSubcontracteQuota;
	}

	public void setTotalSubcontracteQuota(BigDecimal totalSubcontracteQuota) {
		this.totalSubcontracteQuota = totalSubcontracteQuota;
	}

	public Long getReportId() {
		return reportId;
	}

	public void setReportId(Long reportId) {
		this.reportId = reportId;
	}

	public String getEndDateShow() {
		return endDateShow;
	}

	public void setEndDateShow(String endDateShow) {
		this.endDateShow = endDateShow;
	}

	public String getStartDateShow() {
		return startDateShow;
	}

	public void setStartDateShow(String startDateShow) {
		this.startDateShow = startDateShow;
	}

	public String getNotificationAwardDateShow() {
		return notificationAwardDateShow;
	}

	public void setNotificationAwardDateShow(String notificationAwardDateShow) {
		this.notificationAwardDateShow = notificationAwardDateShow;
	}

	public String getBiddingFormName() {
		return biddingFormName;
	}

	public void setBiddingFormName(String biddingFormName) {
		this.biddingFormName = biddingFormName;
	}

	public String getPaymentMethodName() {
		return paymentMethodName;
	}

	public void setPaymentMethodName(String paymentMethodName) {
		this.paymentMethodName = paymentMethodName;
	}

	public String getPaymentGuaranteeFormName() {
		return paymentGuaranteeFormName;
	}

	public void setPaymentGuaranteeFormName(String paymentGuaranteeFormName) {
		this.paymentGuaranteeFormName = paymentGuaranteeFormName;
	}

	public String getAdvancePaymentGuaranteeFormName() {
		return advancePaymentGuaranteeFormName;
	}

	public void setAdvancePaymentGuaranteeFormName(String advancePaymentGuaranteeFormName) {
		this.advancePaymentGuaranteeFormName = advancePaymentGuaranteeFormName;
	}

	public String getPerformanceGuaranteeFormName() {
		return performanceGuaranteeFormName;
	}

	public void setPerformanceGuaranteeFormName(String performanceGuaranteeFormName) {
		this.performanceGuaranteeFormName = performanceGuaranteeFormName;
	}

	public String getWarrantyDepositFormName() {
		return warrantyDepositFormName;
	}

	public void setWarrantyDepositFormName(String warrantyDepositFormName) {
		this.warrantyDepositFormName = warrantyDepositFormName;
	}

	public String getSignStatusName() {
		return signStatusName;
	}

	public void setSignStatusName(String signStatusName) {
		this.signStatusName = signStatusName;
	}

	public String getWaiverPriority() {
		return waiverPriority;
	}

	public void setWaiverPriority(String waiverPriority) {
		this.waiverPriority = waiverPriority;
	}

	public BigDecimal getConstructionInstallationFee() {
		return constructionInstallationFee;
	}

	public void setConstructionInstallationFee(BigDecimal constructionInstallationFee) {
		this.constructionInstallationFee = constructionInstallationFee;
	}

	public BigDecimal getConstructionInstallationFeeProportion() {
		return constructionInstallationFeeProportion;
	}

	public void setConstructionInstallationFeeProportion(BigDecimal constructionInstallationFeeProportion) {
		this.constructionInstallationFeeProportion = constructionInstallationFeeProportion;
	}

	public String getConstructionInstallationFeePriceMethod() {
		return constructionInstallationFeePriceMethod;
	}

	public void setConstructionInstallationFeePriceMethod(String constructionInstallationFeePriceMethod) {
		this.constructionInstallationFeePriceMethod = constructionInstallationFeePriceMethod;
	}

	public BigDecimal getInternalRate() {
		return internalRate;
	}

	public void setInternalRate(BigDecimal internalRate) {
		this.internalRate = internalRate;
	}

	public String getRevenueModel() {
		return revenueModel;
	}

	public void setRevenueModel(String revenueModel) {
		this.revenueModel = revenueModel;
	}

	public BigDecimal getRevenueReturnCycle() {
		return revenueReturnCycle;
	}

	public void setRevenueReturnCycle(BigDecimal revenueReturnCycle) {
		this.revenueReturnCycle = revenueReturnCycle;
	}

	public BigDecimal getGeneralConstructionProfit() {
		return generalConstructionProfit;
	}

	public void setGeneralConstructionProfit(BigDecimal generalConstructionProfit) {
		this.generalConstructionProfit = generalConstructionProfit;
	}

	public BigDecimal getTotalInvestment() {
		return totalInvestment;
	}

	public void setTotalInvestment(BigDecimal totalInvestment) {
		this.totalInvestment = totalInvestment;
	}

	public String getEstateProject() {
		return estateProject;
	}

	public void setEstateProject(String estateProject) {
		this.estateProject = estateProject;
	}

	public String getAdvancePaymentExit() {
		return advancePaymentExit;
	}

	public void setAdvancePaymentExit(String advancePaymentExit) {
		this.advancePaymentExit = advancePaymentExit;
	}

	public BigDecimal getPaymentPeriod() {
		return paymentPeriod;
	}

	public void setPaymentPeriod(BigDecimal paymentPeriod) {
		this.paymentPeriod = paymentPeriod;
	}

	public String getDurationLiquidatedDamagesUpperLimitExit() {
		return durationLiquidatedDamagesUpperLimitExit;
	}

	public void setDurationLiquidatedDamagesUpperLimitExit(String durationLiquidatedDamagesUpperLimitExit) {
		this.durationLiquidatedDamagesUpperLimitExit = durationLiquidatedDamagesUpperLimitExit;
	}

	public String getSettlementTimeLimitSure() {
		return settlementTimeLimitSure;
	}

	public void setSettlementTimeLimitSure(String settlementTimeLimitSure) {
		this.settlementTimeLimitSure = settlementTimeLimitSure;
	}

	public String getCashPerformanceBond() {
		return cashPerformanceBond;
	}

	public void setCashPerformanceBond(String cashPerformanceBond) {
		this.cashPerformanceBond = cashPerformanceBond;
	}

	public String getPeriodBreachNoLimit() {
		return periodBreachNoLimit;
	}

	public void setPeriodBreachNoLimit(String periodBreachNoLimit) {
		this.periodBreachNoLimit = periodBreachNoLimit;
	}

	public String getQualityBreachNoLimit() {
		return qualityBreachNoLimit;
	}

	public void setQualityBreachNoLimit(String qualityBreachNoLimit) {
		this.qualityBreachNoLimit = qualityBreachNoLimit;
	}

	public String getProjectOperationBenefit() {
		return projectOperationBenefit;
	}

	public void setProjectOperationBenefit(String projectOperationBenefit) {
		this.projectOperationBenefit = projectOperationBenefit;
	}

	public String getProceduresLack() {
		return proceduresLack;
	}

	public void setProceduresLack(String proceduresLack) {
		this.proceduresLack = proceduresLack;
	}

	public String getMonthlyProgressPayment() {
		return monthlyProgressPayment;
	}

	public void setMonthlyProgressPayment(String monthlyProgressPayment) {
		this.monthlyProgressPayment = monthlyProgressPayment;
	}

	public String getAcceptancePaymentProportion() {
		return acceptancePaymentProportion;
	}

	public void setAcceptancePaymentProportion(String acceptancePaymentProportion) {
		this.acceptancePaymentProportion = acceptancePaymentProportion;
	}

	public String getAdvanceMoney() {
		return advanceMoney;
	}

	public void setAdvanceMoney(String advanceMoney) {
		this.advanceMoney = advanceMoney;
	}

	public String getNonCash() {
		return nonCash;
	}

	public void setNonCash(String nonCash) {
		this.nonCash = nonCash;
	}

	public String getFixedLumpSum() {
		return fixedLumpSum;
	}

	public void setFixedLumpSum(String fixedLumpSum) {
		this.fixedLumpSum = fixedLumpSum;
	}

	public String getUnconditional() {
		return unconditional;
	}

	public void setUnconditional(String unconditional) {
		this.unconditional = unconditional;
	}

	public String getNonFinancial() {
		return nonFinancial;
	}

	public void setNonFinancial(String nonFinancial) {
		this.nonFinancial = nonFinancial;
	}

	public String getContractStandardFinish() {
		return contractStandardFinish;
	}

	public void setContractStandardFinish(String contractStandardFinish) {
		this.contractStandardFinish = contractStandardFinish;
	}


//	public List<IncontractReviewContentVO> getBusinessList() {
//		return businessList;
//	}
//
//	public void setBusinessList(List<IncontractReviewContentVO> businessList) {
//		this.businessList = businessList;
//	}



	public String getOtherPaymentCondition() {
        return otherPaymentCondition;
    }
    public void setOtherPaymentCondition(String otherPaymentCondition) {
        this.otherPaymentCondition = otherPaymentCondition;
    }

	public String getSettlementTimeLimitShow() {
		return settlementTimeLimitShow;
	}

	public void setSettlementTimeLimitShow(String settlementTimeLimitShow) {
		this.settlementTimeLimitShow = settlementTimeLimitShow;
	}

	public String getFundSource() {
		return fundSource;
	}

	public void setFundSource(String fundSource) {
		this.fundSource = fundSource;
	}

	public String getQualityLiquidatedDamagesUpperLimitExit() {
		return qualityLiquidatedDamagesUpperLimitExit;
	}

	public void setQualityLiquidatedDamagesUpperLimitExit(String qualityLiquidatedDamagesUpperLimitExit) {
		this.qualityLiquidatedDamagesUpperLimitExit = qualityLiquidatedDamagesUpperLimitExit;
	}

	public Long getUserDeptId() {
		return userDeptId;
	}

	public void setUserDeptId(Long userDeptId) {
		this.userDeptId = userDeptId;
	}

	public BigDecimal getAfterChangeAmount() {
		return afterChangeAmount;
	}

	public void setAfterChangeAmount(BigDecimal afterChangeAmount) {
		this.afterChangeAmount = afterChangeAmount;
	}

	public BigDecimal getChangeAmount() {
		return changeAmount;
	}

	public void setChangeAmount(BigDecimal changeAmount) {
		this.changeAmount = changeAmount;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

    public String getQualityAgreementName() {
        return qualityAgreementName;
    }

    public void setQualityAgreementName(String qualityAgreementName) {
        this.qualityAgreementName = qualityAgreementName;
    }

    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getAgentDeptId() {
        return agentDeptId;
    }

    @ReferDeserialTransfer
    public void setAgentDeptId(Long agentDeptId) {
        this.agentDeptId = agentDeptId;
    }

    public String getAgentDeptName() {
        return agentDeptName;
    }

    public void setAgentDeptName(String agentDeptName) {
        this.agentDeptName = agentDeptName;
    }

    public String getBooktype() {
        return booktype;
    }

    public void setBooktype(String booktype) {
        this.booktype = booktype;
    }
}
