package com.ejianc.business.zjkjcost.node.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.zjkjcost.node.vo.NodeGrantDetailVO;

/**
 * 节点考核-节点目标奖金考核发放
 *
 * @author generator
 *
 */
@ApiModel("节点考核-节点目标奖金考核发放")
public class NodeGrantVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("分配金额")
    private BigDecimal distributionMny;
    @ApiModelProperty("实发金额")
    private BigDecimal actualMny;
    @ApiModelProperty("工程项目节点目标奖金审批id")
    private Long nodeApprovalId; // 工程项目节点目标奖金审批id
    @ApiModelProperty("工程项目节点目标奖金审批单号")
    private String nodeApprovalCode; // 工程项目节点目标奖金审批单号
    private String billStateName;
    private BigDecimal chairmanCashMny; // 所属单位董事长兑现金额

    @ApiModelProperty("节点考核-节点目标奖金考核发放-明细")
    private List<NodeGrantDetailVO> nodeGrantDetailList = new ArrayList<>();

    @ReferSerialTransfer(referCode="NodeApprovalRef")
    public Long getNodeApprovalId() {
        return nodeApprovalId;
    }

    @ReferDeserialTransfer
    public void setNodeApprovalId(Long nodeApprovalId) {
        this.nodeApprovalId = nodeApprovalId;
    }

    public String getNodeApprovalCode() {
        return nodeApprovalCode;
    }

    public void setNodeApprovalCode(String nodeApprovalCode) {
        this.nodeApprovalCode = nodeApprovalCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 分配金额
     */
    public BigDecimal getDistributionMny() {
        return distributionMny;
    }

    /**
     * 分配金额
     */
    public void setDistributionMny(BigDecimal distributionMny) {
        this.distributionMny = distributionMny;
    }
    /**
     * 实发金额
     */
    public BigDecimal getActualMny() {
        return actualMny;
    }

    /**
     * 实发金额
     */
    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }

     /**
      * 节点考核-节点目标奖金考核发放-明细
      */
      public List<NodeGrantDetailVO> getNodeGrantDetailList() {
         return nodeGrantDetailList;
      }
     /**
      * 节点考核-节点目标奖金考核发放-明细
      */
     public void setNodeGrantDetailList(List<NodeGrantDetailVO> nodeGrantDetailList) {
         this.nodeGrantDetailList = nodeGrantDetailList;
     }

    public BigDecimal getChairmanCashMny() {
        return chairmanCashMny;
    }

    public void setChairmanCashMny(BigDecimal chairmanCashMny) {
        this.chairmanCashMny = chairmanCashMny;
    }
}
