package com.ejianc.business.zjkjcost.manage.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 项目目标管理责任书评审表
 *
 * @author generator
 *
 */
@ApiModel("项目目标管理责任书评审表")
public class ReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long bookId; // 责任书id
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目部id")
    private Long orgId;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("建筑面积")
    private String builtArea;
    @ApiModelProperty("合同额")
    private BigDecimal zbContractMny;
    @ApiModelProperty("其中自行施工额")
    private BigDecimal zsContractMny;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("合同开工日期")
    private Date startDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("合同竣工日期")
    private Date endDate;
    @ApiModelProperty("合同质量目标")
    private String qualityStandard;
    @ApiModelProperty("合同安全目标")
    private String safetyStandard;
    @ApiModelProperty("评审结论-项目部经理")
    private String xmReviewMsg;
    @ApiModelProperty("评审结论-商务管理部")
    private String swReviewMsg;
    @ApiModelProperty("评审结论-建造管理部")
    private String jzReviewMsg;
    @ApiModelProperty("评审结论-工程技术研究中心")
    private String gcReviewMsg;
    @ApiModelProperty("评审结论-安全生产监督管理部")
    private String aqReviewMsg;
    @ApiModelProperty("评审结论- 财务资金部")
    private String cwReviewMsg;
    @ApiModelProperty("评审结论- 综合办公室")
    private String zhReviewMsg;
    @ApiModelProperty("评审结论-分管领导审批")
    private String fgReviewMsg;
    @ApiModelProperty("评审结论-总经理")
    private String zjlReviewMsg;
    @ApiModelProperty("评审结论-董事长")
    private String dszReviewMsg;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ReferSerialTransfer(referCode="refBook")
    public Long getBookId() {
        return bookId;
    }
    @ReferDeserialTransfer
    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目部id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 建筑面积
     */
    public String getBuiltArea() {
        return builtArea;
    }

    /**
     * 建筑面积
     */
    public void setBuiltArea(String builtArea) {
        this.builtArea = builtArea;
    }
    /**
     * 合同额
     */
    public BigDecimal getZbContractMny() {
        return zbContractMny;
    }

    /**
     * 合同额
     */
    public void setZbContractMny(BigDecimal zbContractMny) {
        this.zbContractMny = zbContractMny;
    }
    /**
     * 其中自行施工额
     */
    public BigDecimal getZsContractMny() {
        return zsContractMny;
    }

    /**
     * 其中自行施工额
     */
    public void setZsContractMny(BigDecimal zsContractMny) {
        this.zsContractMny = zsContractMny;
    }
    /**
     * 合同开工日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 合同竣工日期
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 合同质量目标
     */
    public String getQualityStandard() {
        return qualityStandard;
    }

    /**
     * 合同质量目标
     */
    public void setQualityStandard(String qualityStandard) {
        this.qualityStandard = qualityStandard;
    }
    /**
     * 合同安全目标
     */
    public String getSafetyStandard() {
        return safetyStandard;
    }

    /**
     * 合同安全目标
     */
    public void setSafetyStandard(String safetyStandard) {
        this.safetyStandard = safetyStandard;
    }
    /**
     * 评审结论-项目部经理
     */
    public String getXmReviewMsg() {
        return xmReviewMsg;
    }

    /**
     * 评审结论-项目部经理
     */
    public void setXmReviewMsg(String xmReviewMsg) {
        this.xmReviewMsg = xmReviewMsg;
    }
    /**
     * 评审结论-商务管理部
     */
    public String getSwReviewMsg() {
        return swReviewMsg;
    }

    /**
     * 评审结论-商务管理部
     */
    public void setSwReviewMsg(String swReviewMsg) {
        this.swReviewMsg = swReviewMsg;
    }
    /**
     * 评审结论-建造管理部
     */
    public String getJzReviewMsg() {
        return jzReviewMsg;
    }

    /**
     * 评审结论-建造管理部
     */
    public void setJzReviewMsg(String jzReviewMsg) {
        this.jzReviewMsg = jzReviewMsg;
    }
    /**
     * 评审结论-工程技术研究中心
     */
    public String getGcReviewMsg() {
        return gcReviewMsg;
    }

    /**
     * 评审结论-工程技术研究中心
     */
    public void setGcReviewMsg(String gcReviewMsg) {
        this.gcReviewMsg = gcReviewMsg;
    }
    /**
     * 评审结论-安全生产监督管理部
     */
    public String getAqReviewMsg() {
        return aqReviewMsg;
    }

    /**
     * 评审结论-安全生产监督管理部
     */
    public void setAqReviewMsg(String aqReviewMsg) {
        this.aqReviewMsg = aqReviewMsg;
    }
    /**
     * 评审结论- 财务资金部
     */
    public String getCwReviewMsg() {
        return cwReviewMsg;
    }

    /**
     * 评审结论- 财务资金部
     */
    public void setCwReviewMsg(String cwReviewMsg) {
        this.cwReviewMsg = cwReviewMsg;
    }
    /**
     * 评审结论- 综合办公室
     */
    public String getZhReviewMsg() {
        return zhReviewMsg;
    }

    /**
     * 评审结论- 综合办公室
     */
    public void setZhReviewMsg(String zhReviewMsg) {
        this.zhReviewMsg = zhReviewMsg;
    }
    /**
     * 评审结论-分管领导审批
     */
    public String getFgReviewMsg() {
        return fgReviewMsg;
    }

    /**
     * 评审结论-分管领导审批
     */
    public void setFgReviewMsg(String fgReviewMsg) {
        this.fgReviewMsg = fgReviewMsg;
    }
    /**
     * 评审结论-总经理
     */
    public String getZjlReviewMsg() {
        return zjlReviewMsg;
    }

    /**
     * 评审结论-总经理
     */
    public void setZjlReviewMsg(String zjlReviewMsg) {
        this.zjlReviewMsg = zjlReviewMsg;
    }
    /**
     * 评审结论-董事长
     */
    public String getDszReviewMsg() {
        return dszReviewMsg;
    }

    /**
     * 评审结论-董事长
     */
    public void setDszReviewMsg(String dszReviewMsg) {
        this.dszReviewMsg = dszReviewMsg;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

}
