package com.ejianc.business.zjkjcost.manage.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;


/**
 * 目标责任书-项目目标管理责任书变更
 *
 * @author generator
 *
 */
public class ChangeBookVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long bookId; // 项目目标管理责任书id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private String projectLocation; // 工程地点
    private String builtArea; // 建筑面积
    private String structuralStyle; // 结构形式
    private String projectScale; // 项目规模
    private String priceMethod; // 计价方式
    private String qualityStandard; // 质量标准
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工日期
    private BigDecimal zbContractMny; // 总包合同额
    private BigDecimal zsContractMny; // 自施合同额
    private BigDecimal otherContractMny; // 其他合同额(集成)
    private String client; // 委托人
    private String trustee; // 受托人
    private Integer duration; // 合同总工期
    private Long contractCategoryId; // 合同类别
    private String contractCategoryName; // 合同类别名称
    private String constructionQuality; // 工程质量
    private String safetyProduction; // 安全生产
    private BigDecimal icImage; // IC形象
    private BigDecimal upPayment; // 上缴款
    private BigDecimal riskFund; // 风险金预留
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private BigDecimal turninBase; // 上缴基数(不含税收入)
    private BigDecimal responsibilityCost; // 责任成本(不含税成本)
    private BigDecimal allScale; // 整体上缴比例(B值)
    private BigDecimal amountPaid; // 上缴金额(暂定，随结算金额调整)
    private BigDecimal preBid; // 标前(A值)(承接利润率)
    private String memo; // 备注
    private Long fileId; // word合同编辑文件id
    private Long constructionUnit; // 建设单位id
    private String constructionUnitName; // 建设单位名称
    private Integer isChange; // 是否变更(0:是，1:否)
    private String changeReason; // 变更原因


    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }
    public String getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(String builtArea) {
        this.builtArea = builtArea;
    }
    public String getStructuralStyle() {
        return structuralStyle;
    }

    public void setStructuralStyle(String structuralStyle) {
        this.structuralStyle = structuralStyle;
    }
    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }
    public String getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
    }
    public String getQualityStandard() {
        return qualityStandard;
    }

    public void setQualityStandard(String qualityStandard) {
        this.qualityStandard = qualityStandard;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getZbContractMny() {
        return zbContractMny;
    }

    public void setZbContractMny(BigDecimal zbContractMny) {
        this.zbContractMny = zbContractMny;
    }
    public BigDecimal getZsContractMny() {
        return zsContractMny;
    }

    public void setZsContractMny(BigDecimal zsContractMny) {
        this.zsContractMny = zsContractMny;
    }
    public BigDecimal getOtherContractMny() {
        return otherContractMny;
    }

    public void setOtherContractMny(BigDecimal otherContractMny) {
        this.otherContractMny = otherContractMny;
    }
    public String getClient() {
        return client;
    }

    public void setClient(String client) {
        this.client = client;
    }
    public String getTrustee() {
        return trustee;
    }

    public void setTrustee(String trustee) {
        this.trustee = trustee;
    }
    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }
    @ReferSerialTransfer(referCode="contractCategory")
    public Long getContractCategoryId() {
        return contractCategoryId;
    }
    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public String getConstructionQuality() {
        return constructionQuality;
    }

    public void setConstructionQuality(String constructionQuality) {
        this.constructionQuality = constructionQuality;
    }
    public String getSafetyProduction() {
        return safetyProduction;
    }

    public void setSafetyProduction(String safetyProduction) {
        this.safetyProduction = safetyProduction;
    }
    public BigDecimal getIcImage() {
        return icImage;
    }

    public void setIcImage(BigDecimal icImage) {
        this.icImage = icImage;
    }
    public BigDecimal getUpPayment() {
        return upPayment;
    }

    public void setUpPayment(BigDecimal upPayment) {
        this.upPayment = upPayment;
    }
    public BigDecimal getRiskFund() {
        return riskFund;
    }

    public void setRiskFund(BigDecimal riskFund) {
        this.riskFund = riskFund;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getTurninBase() {
        return turninBase;
    }

    public void setTurninBase(BigDecimal turninBase) {
        this.turninBase = turninBase;
    }
    public BigDecimal getResponsibilityCost() {
        return responsibilityCost;
    }

    public void setResponsibilityCost(BigDecimal responsibilityCost) {
        this.responsibilityCost = responsibilityCost;
    }
    public BigDecimal getAllScale() {
        return allScale;
    }

    public void setAllScale(BigDecimal allScale) {
        this.allScale = allScale;
    }
    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }
    public BigDecimal getPreBid() {
        return preBid;
    }

    public void setPreBid(BigDecimal preBid) {
        this.preBid = preBid;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getConstructionUnit() {
        return constructionUnit;
    }
    @ReferDeserialTransfer
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }
    public Integer getIsChange() {
        return isChange;
    }

    public void setIsChange(Integer isChange) {
        this.isChange = isChange;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
}
