package com.ejianc.business.zjkjcost.node.service.impl;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.node.mapper.NodeGrantMapper;
import com.ejianc.business.zjkjcost.node.bean.NodeGrantEntity;
import com.ejianc.business.zjkjcost.node.service.INodeGrantService;

import java.util.Arrays;

/**
 * 节点考核-节点目标奖金考核发放
 * 
 * @author generator
 * 
 */
@Service("nodeGrantService")
public class NodeGrantServiceImpl extends BaseServiceImpl<NodeGrantMapper, NodeGrantEntity> implements INodeGrantService{
    /**
     * 一个合同下只能有一个自由态的单据
     *
     * @param contractId 合同id
     * @param id         本单据id
     * @return 校验结果：true 校验失败！ false：校验通过
     */
    @Override
    public boolean checkOnly(Long contractId, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, Arrays.asList(1, 3)));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        return CollectionUtils.isNotEmpty(super.queryList(queryParam, false));
    }
}
